/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client;

import java.util.ArrayList;
import java.util.List;
import org.matheclipse.parser.client.Scanner;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IParserFactory;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.operator.ASTNodeFactory;
import org.matheclipse.parser.client.operator.InfixOperator;
import org.matheclipse.parser.client.operator.Operator;
import org.matheclipse.parser.client.operator.PostfixOperator;
import org.matheclipse.parser.client.operator.PrefixOperator;

public class Parser
extends Scanner {
    private final boolean fRelaxedSyntax;
    private final boolean fPackageMode;
    private List<ASTNode> fNodeList = null;
    public static final SymbolNode DERIVATIVE = new SymbolNode("Derivative");

    public Parser() {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, false, false);
    }

    public Parser(boolean relaxedSyntax) throws SyntaxError {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
    }

    public Parser(boolean relaxedSyntax, boolean packageMode) throws SyntaxError {
        this(ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax, packageMode);
    }

    public Parser(IParserFactory factory, boolean relaxedSyntax) throws SyntaxError {
        this(factory, relaxedSyntax, false);
    }

    public Parser(IParserFactory factory, boolean relaxedSyntax, boolean packageMode) throws SyntaxError {
        this.fRelaxedSyntax = relaxedSyntax;
        this.fFactory = factory;
        this.fPackageMode = packageMode;
        if (this.fPackageMode) {
            this.fNodeList = new ArrayList<ASTNode>(256);
        }
    }

    public void setFactory(IParserFactory factory) {
        this.fFactory = factory;
    }

    public IParserFactory getFactory() {
        return this.fFactory;
    }

    private void getArguments(FunctionNode function) throws SyntaxError {
        while (true) {
            function.add(this.parseOperators(this.parsePrimary(), 0));
            if (this.fToken != 134) break;
            this.getNextToken();
        }
    }

    private PrefixOperator determinePrefixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PrefixOperator)) continue;
            return (PrefixOperator)oper;
        }
        return null;
    }

    private PostfixOperator determinePostfixOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof PostfixOperator)) continue;
            return (PostfixOperator)oper;
        }
        return null;
    }

    private InfixOperator determineBinaryOperator() {
        Operator oper = null;
        for (int i = 0; i < this.fOperList.size(); ++i) {
            oper = (Operator)this.fOperList.get(i);
            if (!(oper instanceof InfixOperator)) continue;
            return (InfixOperator)oper;
        }
        return null;
    }

    private ASTNode parseArguments(ASTNode lhs) {
        if (this.fRelaxedSyntax) {
            if (this.fToken == 12) {
                lhs = this.getFunctionArguments(lhs);
            } else if (this.fToken == 14) {
                lhs = this.getFunction(lhs);
            }
        } else if (this.fToken == 12) {
            lhs = this.getFunctionArguments(lhs);
        }
        return lhs;
    }

    private ASTNode parsePrimary() {
        if (this.fToken == 31) {
            if (this.fOperatorString.equals(".")) {
                this.fCurrentChar = (char)46;
                return this.getNumber(false);
            }
            PrefixOperator prefixOperator = this.determinePrefixOperator();
            if (prefixOperator != null) {
                this.getNextToken();
                ASTNode temp = this.parseLookaheadOperator(prefixOperator.getPrecedence());
                if (prefixOperator.getFunctionName().equals("PreMinus") && temp instanceof NumberNode) {
                    ((NumberNode)temp).toggleSign();
                    return temp;
                }
                return prefixOperator.createFunction(this.fFactory, temp);
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no prefix operator.");
        }
        return this.getPart();
    }

    private ASTNode parseLookaheadOperator(int min_precedence) {
        ASTNode rhs = this.parsePrimary();
        while (true) {
            int lookahead = this.fToken;
            if (this.fToken == 16 || this.fToken == 14 || this.fToken == 138 || this.fToken == 136 || this.fToken == 139) {
                if (this.fPackageMode && this.fToken == 138 && this.fLastChar == '\n') {
                    return rhs;
                }
                InfixOperator timesOperator = (InfixOperator)this.fFactory.get("Times");
                if (timesOperator.getPrecedence() > min_precedence) {
                    rhs = this.parseOperators(rhs, timesOperator.getPrecedence());
                    continue;
                }
                if (timesOperator.getPrecedence() != min_precedence || timesOperator.getGrouping() != 1) break;
                rhs = this.parseOperators(rhs, timesOperator.getPrecedence());
                continue;
            }
            if (lookahead != 31) break;
            InfixOperator infixOperator = this.determineBinaryOperator();
            if (infixOperator != null) {
                if (infixOperator.getPrecedence() > min_precedence) {
                    rhs = this.parseOperators(rhs, infixOperator.getPrecedence());
                    continue;
                }
                if (infixOperator.getPrecedence() != min_precedence || infixOperator.getGrouping() != 1) break;
                rhs = this.parseOperators(rhs, infixOperator.getPrecedence());
                continue;
            }
            PostfixOperator postfixOperator = this.determinePostfixOperator();
            if (postfixOperator == null || postfixOperator.getPrecedence() <= min_precedence) break;
            this.getNextToken();
            rhs = postfixOperator.createFunction(this.fFactory, rhs);
        }
        return rhs;
    }

    private ASTNode parseOperators(ASTNode lhs, int min_precedence) {
        block12: {
            ASTNode rhs = null;
            while (true) {
                if (this.fToken == 16 || this.fToken == 14 || this.fToken == 138 || this.fToken == 136 || this.fToken == 139) {
                    if (this.fPackageMode && this.fToken == 138 && this.fLastChar == '\n') {
                        return lhs;
                    }
                    Operator oper = this.fFactory.get("Times");
                    if (oper.getPrecedence() >= min_precedence) {
                        rhs = this.parseLookaheadOperator(oper.getPrecedence());
                        lhs = this.fFactory.createFunction(this.fFactory.createSymbol(oper.getFunctionName()), lhs, rhs);
                        continue;
                    }
                } else if (this.fToken != 31) {
                    if (this.fToken == 146) {
                        this.getNextToken();
                        lhs = this.fFactory.createFunction(DERIVATIVE, lhs);
                        lhs = this.parseArguments(lhs);
                        continue;
                    }
                } else {
                    InfixOperator infixOperator = this.determineBinaryOperator();
                    if (infixOperator != null) {
                        if (infixOperator.getPrecedence() >= min_precedence) {
                            this.getNextToken();
                            rhs = this.parseLookaheadOperator(infixOperator.getPrecedence());
                            lhs = infixOperator.createFunction(this.fFactory, lhs, rhs);
                            continue;
                        }
                    } else {
                        PostfixOperator postfixOperator = this.determinePostfixOperator();
                        if (postfixOperator == null) break;
                        if (postfixOperator.getPrecedence() >= min_precedence) {
                            this.getNextToken();
                            lhs = postfixOperator.createFunction(this.fFactory, lhs);
                            lhs = this.parseArguments(lhs);
                            continue;
                        }
                    }
                }
                break block12;
                break;
            }
            this.throwSyntaxError("Operator: " + this.fOperatorString + " is no infix or postfix operator.");
        }
        return lhs;
    }

    public ASTNode parse(String expression) throws SyntaxError {
        this.initialize(expression);
        ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
        if (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            this.throwSyntaxError("End-of-file not reached.");
        }
        return temp;
    }

    public List<ASTNode> parseList(String expression) throws SyntaxError {
        this.initialize(expression);
        ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
        this.fNodeList.add(temp);
        while (this.fToken != 0) {
            if (this.fToken == 15) {
                this.throwSyntaxError("Too many closing ')'; End-of-file not reached.");
            }
            if (this.fToken == 17) {
                this.throwSyntaxError("Too many closing '}'; End-of-file not reached.");
            }
            if (this.fToken == 13) {
                this.throwSyntaxError("Too many closing ']'; End-of-file not reached.");
            }
            temp = this.parseOperators(this.parsePrimary(), 0);
            this.fNodeList.add(temp);
        }
        return this.fNodeList;
    }

    private ASTNode getNumber(boolean negative) throws SyntaxError {
        ASTNode temp = null;
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        try {
            if (negative) {
                number = '-' + number;
            }
            temp = numFormat < 0 ? this.fFactory.createDouble(number) : this.fFactory.createInteger(number, numFormat);
        }
        catch (Throwable e) {
            this.throwSyntaxError("Number format error: " + number, number.length());
        }
        this.getNextToken();
        return temp;
    }

    private int getIntegerNumber() throws SyntaxError {
        Object[] result = this.getNumberString();
        String number = (String)result[0];
        int numFormat = (Integer)result[1];
        int intValue = 0;
        try {
            intValue = Integer.parseInt(number, numFormat);
        }
        catch (NumberFormatException e) {
            this.throwSyntaxError("Number format error (not an int type): " + number, number.length());
        }
        this.getNextToken();
        return intValue;
    }

    private SymbolNode getSymbol() throws SyntaxError {
        String identifier = this.getIdentifier();
        if (!this.fFactory.isValidIdentifier(identifier)) {
            this.throwSyntaxError("Invalid identifier: " + identifier + " detected.");
        }
        SymbolNode symbol = this.fFactory.createSymbol(identifier);
        this.getNextToken();
        return symbol;
    }

    private ASTNode getString() throws SyntaxError {
        StringBuffer ident = this.getStringBuffer();
        this.getNextToken();
        return this.fFactory.createString(ident);
    }

    private ASTNode getList() throws SyntaxError {
        FunctionNode function = this.fFactory.createFunction(this.fFactory.createSymbol("List"));
        this.getNextToken();
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        this.getArguments(function);
        if (this.fToken == 17) {
            this.getNextToken();
            return function;
        }
        this.throwSyntaxError("'}' expected.");
        return null;
    }

    FunctionNode getFunction(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        this.getNextToken();
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return function;
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(function);
                }
                return function;
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.getArguments(function);
        if (this.fRelaxedSyntax) {
            if (this.fToken == 15) {
                this.getNextToken();
                if (this.fToken == 14) {
                    return function;
                }
                if (this.fToken == 12) {
                    return this.getFunctionArguments(function);
                }
                return function;
            }
        } else if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        if (this.fRelaxedSyntax) {
            this.throwSyntaxError("')' expected.");
        } else {
            this.throwSyntaxError("']' expected.");
        }
        return null;
    }

    FunctionNode getFunctionArguments(ASTNode head) throws SyntaxError {
        FunctionNode function = this.fFactory.createAST(head);
        this.getNextToken();
        if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.getArguments(function);
        if (this.fToken == 13) {
            this.getNextToken();
            if (this.fToken == 12) {
                return this.getFunctionArguments(function);
            }
            return function;
        }
        this.throwSyntaxError("']' expected.");
        return null;
    }

    private ASTNode getFactor() throws SyntaxError {
        if (this.fToken == 138) {
            ASTNode temp;
            SymbolNode symbol = this.getSymbol();
            if (this.fToken == 137) {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern(symbol, check);
                } else {
                    temp = this.fFactory.createPattern(symbol, null);
                }
            } else if (this.fToken == 143) {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern2(symbol, check);
                } else {
                    temp = this.fFactory.createPattern2(symbol, null);
                }
            } else if (this.fToken == 144) {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern3(symbol, check);
                } else {
                    temp = this.fFactory.createPattern3(symbol, null);
                }
            } else if (this.fToken == 145) {
                this.getNextToken();
                if (this.fToken == 138) {
                    SymbolNode check = this.getSymbol();
                    temp = this.fFactory.createPattern(symbol, check, true);
                } else {
                    temp = this.fFactory.createPattern(symbol, null, true);
                }
            } else {
                temp = symbol;
            }
            return this.parseArguments(temp);
        }
        if (this.fToken == 137) {
            this.getNextToken();
            if (this.fToken == 138) {
                SymbolNode check = this.getSymbol();
                return this.fFactory.createPattern(null, check);
            }
            return this.fFactory.createPattern(null, null);
        }
        if (this.fToken == 143) {
            this.getNextToken();
            if (this.fToken == 138) {
                SymbolNode check = this.getSymbol();
                return this.fFactory.createPattern2(null, check);
            }
            return this.fFactory.createPattern2(null, null);
        }
        if (this.fToken == 144) {
            this.getNextToken();
            if (this.fToken == 138) {
                SymbolNode check = this.getSymbol();
                return this.fFactory.createPattern3(null, check);
            }
            return this.fFactory.createPattern3(null, null);
        }
        if (this.fToken == 145) {
            this.getNextToken();
            if (this.fToken == 138) {
                SymbolNode check = this.getSymbol();
                return this.fFactory.createPattern(null, check, true);
            }
            return this.fFactory.createPattern(null, null, true);
        }
        if (this.fToken == 139) {
            return this.getNumber(false);
        }
        if (this.fToken == 14) {
            this.getNextToken();
            ASTNode temp = this.parseOperators(this.parsePrimary(), 0);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
            if (this.fToken == 14) {
                return this.getTimes(temp);
            }
            return temp;
        }
        if (this.fToken == 16) {
            return this.getList();
        }
        if (this.fToken == 136) {
            return this.getString();
        }
        if (this.fToken == 135) {
            FunctionNode out = this.fFactory.createFunction(this.fFactory.createSymbol("Out"));
            int countPercent = 1;
            this.getNextToken();
            if (this.fToken == 139) {
                countPercent = this.getIntegerNumber();
                out.add(this.fFactory.createInteger(countPercent));
                return out;
            }
            while (this.fToken == 135) {
                ++countPercent;
                this.getNextToken();
            }
            out.add(this.fFactory.createInteger(-countPercent));
            return out;
        }
        if (this.fToken == 141) {
            this.getNextToken();
            FunctionNode slot = this.fFactory.createFunction(this.fFactory.createSymbol("Slot"));
            if (this.fToken == 139) {
                slot.add(this.getNumber(false));
            } else {
                slot.add(this.fFactory.createInteger(1));
            }
            return slot;
        }
        if (this.fToken == 142) {
            this.getNextToken();
            FunctionNode slotSequencce = this.fFactory.createFunction(this.fFactory.createSymbol("SlotSequence"));
            if (this.fToken == 139) {
                slotSequencce.add(this.getNumber(false));
            } else {
                slotSequencce.add(this.fFactory.createInteger(1));
            }
            return slotSequencce;
        }
        switch (this.fToken) {
            case 15: {
                this.throwSyntaxError("Too much open ) in factor.");
                break;
            }
            case 17: {
                this.throwSyntaxError("Too much open } in factor.");
                break;
            }
            case 13: {
                this.throwSyntaxError("Too much open ] in factor.");
            }
        }
        this.throwSyntaxError("Error in factor at character: '" + this.fCurrentChar + "' (" + this.fToken + ")");
        return null;
    }

    private ASTNode getTimes(ASTNode temp) throws SyntaxError {
        FunctionNode func = this.fFactory.createAST(new SymbolNode("Times"));
        func.add(temp);
        do {
            this.getNextToken();
            temp = this.parseOperators(this.parsePrimary(), 0);
            func.add(temp);
            if (this.fToken != 15) {
                this.throwSyntaxError("')' expected.");
            }
            this.getNextToken();
        } while (this.fToken == 14);
        return func;
    }

    private ASTNode getPart() throws SyntaxError {
        ASTNode temp = this.getFactor();
        if (this.fToken != 18) {
            return temp;
        }
        FunctionNode function = null;
        do {
            function = function == null ? this.fFactory.createFunction(this.fFactory.createSymbol("Part"), temp) : this.fFactory.createFunction(this.fFactory.createSymbol("Part"), function);
            do {
                this.getNextToken();
                if (this.fToken == 19) {
                    this.throwSyntaxError("Statement (i.e. index) expected in [[ ]].");
                }
                function.add(this.parseOperators(this.parsePrimary(), 0));
            } while (this.fToken == 134);
            if (this.fToken == 13 && this.fInputString.length() > this.fCurrentPosition && this.fInputString.charAt(this.fCurrentPosition) == ']') {
                ++this.fCurrentPosition;
                this.fToken = 19;
            }
            if (this.fToken != 19) {
                this.throwSyntaxError("']]' expected.");
            }
            this.getNextToken();
        } while (this.fToken == 18);
        return this.parseArguments(function);
    }
}

