/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import com.google.common.base.Function;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorExpr;

public class VisitorReplaceAll
extends VisitorExpr {
    final Function<IExpr, IExpr> fFunction;
    final int fOffset;

    public VisitorReplaceAll(Function<IExpr, IExpr> function) {
        this(function, 0);
    }

    public VisitorReplaceAll(Function<IExpr, IExpr> function, int offset) {
        this.fFunction = function;
        this.fOffset = offset;
    }

    public VisitorReplaceAll(IAST ast) {
        this(ast, 0);
    }

    public VisitorReplaceAll(IAST ast, int offset) {
        this.fFunction = Functors.rules(ast);
        this.fOffset = offset;
    }

    @Override
    public IExpr visit(IInteger element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IFraction element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IComplex element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(INum element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IComplexNum element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(ISymbol element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IPattern element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IStringX element) {
        return this.fFunction.apply(element);
    }

    @Override
    public IExpr visit(IAST ast) {
        IExpr temp = this.fFunction.apply(ast);
        if (temp != null) {
            return temp;
        }
        return this.visitAST(ast);
    }

    @Override
    protected IExpr visitAST(IAST ast) {
        IExpr temp;
        int i;
        IAST result = null;
        for (i = this.fOffset; i < ast.size(); ++i) {
            temp = ((IExpr)ast.get(i)).accept(this);
            if (temp == null) continue;
            result = ast.clone();
            result.set(i++, temp);
            break;
        }
        if (result != null) {
            while (i < ast.size()) {
                temp = ((IExpr)ast.get(i)).accept(this);
                if (temp != null) {
                    result.set(i, temp);
                }
                ++i;
            }
        }
        return result;
    }
}

