/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import com.google.common.base.Predicate;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.IVisitorBoolean;

public class VisitorPredicate
implements IVisitorBoolean {
    int fHeadOffset;
    final Predicate<IExpr> fMatcher;

    public VisitorPredicate(Predicate<IExpr> matcher) {
        this(1, matcher);
    }

    public VisitorPredicate(int hOffset, Predicate<IExpr> matcher) {
        this.fHeadOffset = hOffset;
        this.fMatcher = matcher;
    }

    @Override
    public boolean visit(IInteger element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IFraction element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IComplex element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(INum element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IComplexNum element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(ISymbol element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IPattern element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IPatternSequence element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IStringX element) {
        return this.fMatcher.apply(element);
    }

    @Override
    public boolean visit(IAST list) {
        if (this.fMatcher.apply(list)) {
            return true;
        }
        for (int i = this.fHeadOffset; i < list.size(); ++i) {
            if (!((IExpr)list.get(i)).accept(this)) continue;
            return true;
        }
        return false;
    }
}

