/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.visit;

import com.google.common.base.Function;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.AbstractVisitor;
import org.matheclipse.parser.client.math.MathException;

public class VisitorLevelSpecification
extends AbstractVisitor<IExpr> {
    private final Function<IExpr, IExpr> fFunction;
    private int fFromLevel;
    private int fToLevel;
    private int fFromDepth;
    private int fToDepth;
    private final boolean fIncludeHeads;
    private int fCurrentLevel;
    private int fCurrentDepth;

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, IExpr expr, boolean includeHeads) {
        IExpr levelExpr = F.eval(expr);
        this.fToLevel = -1;
        this.fFromLevel = -1;
        this.fToDepth = 0;
        this.fFromDepth = 0;
        this.fIncludeHeads = includeHeads;
        this.fFunction = function;
        if (levelExpr instanceof IInteger) {
            IInteger value = (IInteger)levelExpr;
            if (value.isNegative()) {
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = value.getBigNumerator().intValue();
                this.fFromLevel = 1;
                this.fToLevel = Integer.MAX_VALUE;
            } else {
                this.fToLevel = value.getBigNumerator().intValue();
                this.fFromLevel = 1;
                this.fFromDepth = Integer.MIN_VALUE;
                this.fToDepth = -1;
            }
            return;
        }
        if (levelExpr.isList()) {
            IAST lst = (IAST)levelExpr;
            if (lst.size() == 2) {
                if (lst.arg1() instanceof IInteger) {
                    IInteger i = (IInteger)lst.arg1();
                    if (i.isNegative()) {
                        this.fFromDepth = i.getBigNumerator().intValue();
                        this.fToDepth = i.getBigNumerator().intValue();
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                        if (this.fToDepth < this.fFromDepth) {
                            throw new MathException("Invalid Level specification: " + levelExpr.toString());
                        }
                    } else {
                        this.fToLevel = i.getBigNumerator().intValue();
                        this.fFromLevel = i.getBigNumerator().intValue();
                        this.fFromDepth = Integer.MIN_VALUE;
                        this.fToDepth = -1;
                        if (this.fToLevel < this.fFromLevel) {
                            throw new MathException("Invalid Level specification: " + levelExpr.toString());
                        }
                    }
                    return;
                }
            } else if (lst.size() == 3) {
                if (lst.arg1() instanceof IInteger && lst.arg2() instanceof IInteger) {
                    IInteger i0 = (IInteger)lst.arg1();
                    IInteger i1 = (IInteger)lst.arg2();
                    if (i0.isNegative() && i1.isNegative()) {
                        this.fFromDepth = i0.getBigNumerator().intValue();
                        this.fToDepth = i1.getBigNumerator().intValue();
                        this.fFromLevel = 0;
                        this.fToLevel = Integer.MAX_VALUE;
                    } else {
                        if (i0.isNegative()) {
                            throw new MathException("Invalid Level specification: " + levelExpr.toString());
                        }
                        if (i1.isNegative()) {
                            this.fFromDepth = Integer.MIN_VALUE;
                            this.fToDepth = i1.getBigNumerator().intValue();
                            this.fFromLevel = i0.getBigNumerator().intValue();
                            this.fToLevel = Integer.MAX_VALUE;
                        } else {
                            this.fFromDepth = Integer.MIN_VALUE;
                            this.fToDepth = -1;
                            this.fFromLevel = i0.getBigNumerator().intValue();
                            this.fToLevel = i1.getBigNumerator().intValue();
                        }
                    }
                    return;
                }
                if (lst.arg1() instanceof IInteger && lst.arg2().isInfinity()) {
                    IInteger i0 = (IInteger)lst.arg1();
                    if (i0.isNegative()) {
                        throw new MathException("Invalid Level specification: " + levelExpr.toString());
                    }
                    this.fFromDepth = Integer.MIN_VALUE;
                    this.fToDepth = -1;
                    this.fFromLevel = i0.getBigNumerator().intValue();
                    this.fToLevel = Integer.MAX_VALUE;
                    return;
                }
            }
        }
        if (levelExpr.equals(F.CInfinity)) {
            this.fToLevel = Integer.MAX_VALUE;
            this.fFromLevel = 1;
            this.fFromDepth = Integer.MIN_VALUE;
            this.fToDepth = -1;
            return;
        }
        throw new MathException("Invalid Level specification: " + levelExpr.toString());
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int level) {
        this(function, level, true);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int level, boolean includeHeads) {
        this(function, level, level, includeHeads);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel) {
        this(function, fromLevel, toLevel, true);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, boolean includeHeads) {
        this(function, fromLevel, toLevel, Integer.MIN_VALUE, -1, includeHeads);
    }

    public VisitorLevelSpecification(Function<IExpr, IExpr> function, int fromLevel, int toLevel, int fromDepth, int toDepth, boolean includeHeads) {
        this.fFunction = function;
        this.fFromLevel = fromLevel;
        this.fToLevel = toLevel;
        this.fCurrentLevel = 0;
        this.fIncludeHeads = includeHeads;
        this.fFromDepth = fromDepth;
        this.fCurrentDepth = -1;
        this.fToDepth = toDepth;
    }

    public void incCurrentLevel() {
        ++this.fCurrentLevel;
    }

    public void decCurrentLevel() {
        --this.fCurrentLevel;
    }

    public boolean isInRange(int level, int depth) {
        return level >= this.fFromLevel && level <= this.fToLevel && depth >= this.fFromDepth && depth <= this.fToDepth;
    }

    @Override
    public IExpr visit(IInteger element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IFraction element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IComplex element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(INum element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IComplexNum element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(ISymbol element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IPattern element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IPatternSequence element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    @Override
    public IExpr visit(IStringX element) {
        this.fCurrentDepth = -1;
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    public IExpr visitExpr(IExpr element) {
        if (this.isInRange(this.fCurrentLevel, -1)) {
            return this.fFunction.apply(element);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExpr visit(IAST ast) {
        IExpr temp;
        int minDepth = -1;
        IAST result = null;
        try {
            ++this.fCurrentLevel;
            if (this.fIncludeHeads) {
                temp = ((IExpr)ast.get(0)).accept(this);
                if (temp != null) {
                    if (result == null) {
                        result = ast.clone();
                    }
                    result.set(0, temp);
                }
                if (this.fCurrentDepth < minDepth) {
                    minDepth = this.fCurrentDepth;
                }
            }
            for (int i = 1; i < ast.size(); ++i) {
                temp = ((IExpr)ast.get(i)).accept(this);
                if (temp != null) {
                    if (result == null) {
                        result = ast.clone();
                    }
                    result.set(i, temp);
                }
                if (this.fCurrentDepth >= minDepth) continue;
                minDepth = this.fCurrentDepth;
            }
        }
        finally {
            --this.fCurrentLevel;
        }
        this.fCurrentDepth = --minDepth;
        if (this.isInRange(this.fCurrentLevel, minDepth)) {
            if (result == null) {
                return this.fFunction.apply(ast);
            }
            temp = this.fFunction.apply(result);
            if (temp != null) {
                return temp;
            }
        }
        return result;
    }
}

