/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    protected Writer fWriter;
    protected String fEncoding;
    private byte[] fBuffer = new byte[1];

    public WriterOutputStream(Writer writer, String encoding) {
        this.fWriter = writer;
        this.fEncoding = encoding;
    }

    public WriterOutputStream(Writer writer) {
        this.fWriter = writer;
    }

    @Override
    public void close() throws IOException {
        this.fWriter.close();
        this.fWriter = null;
        this.fEncoding = null;
    }

    @Override
    public void flush() throws IOException {
        this.fWriter.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.fEncoding == null) {
            this.fWriter.write(new String(b));
        } else {
            this.fWriter.write(new String(b, this.fEncoding));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fEncoding == null) {
            this.fWriter.write(new String(b, off, len));
        } else {
            this.fWriter.write(new String(b, off, len, this.fEncoding));
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.fBuffer[0] = (byte)b;
        this.write(this.fBuffer);
    }
}

