/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Predicate;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class UpperCaseQ
extends AbstractFunctionEvaluator
implements Predicate<IExpr> {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (!(ast.arg1() instanceof IStringX)) {
            throw new WrongNumberOfArguments(ast, 1, ast.size() - 1);
        }
        return F.bool(this.apply(ast.arg1()));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }

    @Override
    public boolean apply(IExpr obj) {
        String str = obj.toString();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch)) continue;
            return false;
        }
        return true;
    }
}

