/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class UnitStep
implements INumeric,
IFunctionEvaluator {
    @Override
    public double evalReal(double[] stack, int top, int size) {
        for (int i = top - size + 1; i < top + 1; ++i) {
            if (!(stack[i] < 0.0)) continue;
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        int size = ast.size();
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                IExpr num;
                IExpr temp = (IExpr)ast.get(i);
                if (temp.isSignedNumber()) {
                    if (((ISignedNumber)temp).complexSign() >= 0) continue;
                    return F.C0;
                }
                if (temp.isNumericFunction() && (num = F.evaln(temp)).isSignedNumber()) {
                    if (((ISignedNumber)num).complexSign() >= 0) continue;
                    return F.C0;
                }
                return null;
            }
        }
        return F.C1;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(228);
    }
}

