/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;
import org.matheclipse.core.visit.VisitorExpr;

public class TrigReduce
implements IFunctionEvaluator {
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher();

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        Validate.checkSize(ast, 2);
        TrigReduceVisitor trigReduceVisitor = new TrigReduceVisitor();
        IExpr result = temp = ast.arg1();
        while (temp != null) {
            result = temp;
            if (temp.isPlus() || temp.isTimes() || temp.isPower()) {
                result = F.evalExpand(temp);
            }
            if ((temp = result.accept(trigReduceVisitor)) == null) continue;
            result = temp;
        }
        return result;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Sin(F.x_), (IExpr)F.Cos(F.y_), F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sin(F.Plus((IExpr)F.x, (IExpr)F.y))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sin(F.Plus((IExpr)F.x, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.y))))));
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Sin(F.x_), (IExpr)F.Sin(F.y_), F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Plus((IExpr)F.x, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.y)))), (IExpr)F.Times(F.CN1, F.C1D2, F.Cos(F.Plus((IExpr)F.x, (IExpr)F.y)))));
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Cos(F.x_), (IExpr)F.Cos(F.y_), F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Plus((IExpr)F.x, (IExpr)F.y))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Plus((IExpr)F.x, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.y))))));
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Sinh(F.x_), (IExpr)F.Cosh(F.y_), F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sinh(F.Plus((IExpr)F.x, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.y)))), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Sinh(F.Plus((IExpr)F.x, (IExpr)F.y)))));
        symbol.setAttributes(128);
    }

    class TrigReduceVisitor
    extends VisitorExpr {
        @Override
        public IExpr visit(IAST ast) {
            IInteger n;
            if (ast.isTimes()) {
                IAST result = ORDERLESS_MATCHER.evaluate(ast);
                if (result != null) {
                    return result;
                }
            } else if (ast.isPower() && ast.arg1().isAST() && ((IExpr)ast.get(2)).isInteger() && (n = (IInteger)ast.get(2)).isPositive()) {
                IAST powerArg1 = (IAST)ast.arg1();
                if (powerArg1.isSin()) {
                    IExpr x = powerArg1.arg1();
                    return F.Times((IExpr)F.Subtract(F.C1D2, F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Times((IExpr)F.C2, x)))), (IExpr)F.Power((IExpr)F.Sin(x), n.subtract(F.C2)));
                }
                if (powerArg1.isCos()) {
                    IExpr x = powerArg1.arg1();
                    return F.Times((IExpr)F.Plus((IExpr)F.C1D2, (IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Cos(F.Times((IExpr)F.C2, x)))), (IExpr)F.Power((IExpr)F.Cos(x), n.subtract(F.C2)));
                }
            }
            return this.visitAST(ast);
        }
    }
}

