/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Transpose
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2);
        int[] dim = ast.arg1().isMatrix();
        if (dim != null) {
            IAST originalMatrix = (IAST)ast.arg1();
            IAST transposedMatrix = F.ast(F.List, dim[1], true);
            for (int i = 1; i <= dim[1]; ++i) {
                transposedMatrix.set(i, F.ast(F.List, dim[0], true));
            }
            for (int i = 1; i <= dim[0]; ++i) {
                AST originalRow = (AST)originalMatrix.get(i);
                for (int j = 1; j <= dim[1]; ++j) {
                    IAST transposedResultRow = (IAST)transposedMatrix.get(j);
                    transposedResultRow.set(i, this.transform((IExpr)originalRow.get(j)));
                }
            }
            transposedMatrix.addEvalFlags(32);
            return transposedMatrix;
        }
        return null;
    }

    protected IExpr transform(IExpr expr) {
        return expr;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

