/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.core.reflection.system.Cancel;
import org.matheclipse.core.reflection.system.ExpandAll;
import org.matheclipse.parser.client.SyntaxError;

public class Together
extends AbstractFunctionEvaluator {
    public static IExpr together(IAST ast) {
        IExpr result;
        IExpr temp = ExpandAll.expandAll(ast, null);
        if (temp == null) {
            temp = ast;
        }
        if (temp.isAST() && (result = Together.togetherPlusTimesPower((IAST)temp)) != null) {
            return F.eval(result);
        }
        return temp;
    }

    private static IAST togetherForEach(IAST ast, IAST result) {
        for (int i = 1; i < ast.size(); ++i) {
            IExpr temp;
            if (!((IExpr)ast.get(i)).isAST() || (temp = Together.togetherNull((IAST)ast.get(i))) == null) continue;
            if (result == null) {
                result = ast.clone();
            }
            result.set(i, temp);
        }
        return result;
    }

    private static IExpr togetherNull(IAST ast) {
        IExpr result;
        boolean evaled = false;
        IExpr temp = ExpandAll.expandAll(ast, null);
        if (temp == null) {
            temp = ast;
        } else {
            evaled = true;
        }
        if (temp.isAST() && (result = Together.togetherPlusTimesPower((IAST)temp)) != null) {
            return F.eval(result);
        }
        if (evaled) {
            return temp;
        }
        return null;
    }

    private static IAST togetherPlus(IAST plusAST) {
        IExpr temp;
        int i;
        if (plusAST.size() <= 2) {
            return null;
        }
        IAST numer = F.ast(F.Plus, plusAST.size(), false);
        IAST denom = F.ast(F.Times, plusAST.size(), false);
        boolean evaled = false;
        for (i = 1; i < plusAST.size(); ++i) {
            IExpr[] parts = Apart.getFractionalPartsRational((IExpr)plusAST.get(i));
            if (parts != null) {
                numer.add(i, parts[0]);
                temp = parts[1];
                if (!temp.isOne()) {
                    evaled = true;
                }
                denom.add(i, temp);
                continue;
            }
            numer.add(i, plusAST.get(i));
            denom.add(i, F.C1);
        }
        if (!evaled) {
            return null;
        }
        for (i = 1; i < plusAST.size(); ++i) {
            IAST ni = F.Times((IExpr)numer.get(i));
            for (int j = 1; j < plusAST.size(); ++j) {
                if (i == j || (temp = (IExpr)denom.get(j)).equals(F.C1)) continue;
                ni.add(temp);
            }
            numer.set(i, ni);
        }
        i = 1;
        while (denom.size() > i) {
            if (denom.equalsAt(i, F.C1)) {
                denom.remove(i);
                continue;
            }
            ++i;
        }
        IExpr exprNumerator = F.evalExpandAll(numer);
        if (denom.size() == 1) {
            return null;
        }
        IExpr exprDenominator = F.evalExpandAll(denom);
        if (!exprDenominator.equals(F.C1)) {
            try {
                IExpr[] result = Cancel.cancelGCD(exprNumerator, exprDenominator);
                if (result != null) {
                    if (result[0].isOne()) {
                        return F.Times(result[1], (IExpr)F.Power(result[2], F.CN1));
                    }
                    return F.Times(result[0], result[1], F.Power(result[2], F.CN1));
                }
                return null;
            }
            catch (JASConversionException jce) {
                // empty catch block
            }
        }
        return F.Times(exprNumerator, (IExpr)F.Power(exprDenominator, F.CN1));
    }

    private static IExpr togetherPlusTimesPower(IAST ast) {
        if (ast.isPlus()) {
            IAST result = null;
            if ((result = Together.togetherForEach(ast, result)) != null) {
                return Together.togetherPlus(result);
            }
            return Together.togetherPlus(ast);
        }
        if (ast.isTimes() || ast.isPower()) {
            try {
                IExpr temp;
                IAST result = null;
                if (ast.isTimes()) {
                    result = Together.togetherForEach(ast, result);
                } else if (ast.arg1().isAST() && (temp = Together.togetherNull((IAST)ast.arg1())) != null) {
                    if (result == null) {
                        result = ast.clone();
                    }
                    result.set(1, temp);
                }
                if (result != null) {
                    IExpr temp2;
                    temp = F.eval(result);
                    if ((temp.isTimes() || temp.isPower()) && (temp2 = Cancel.cancelPowerTimes((IAST)temp)) != null) {
                        return temp2;
                    }
                    return temp;
                }
                return Cancel.cancelPowerTimes(ast);
            }
            catch (JASConversionException jce) {
                jce.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        if (arg1.isAtom()) {
            return arg1;
        }
        if (arg1.isAST() && (temp = Together.togetherNull((IAST)arg1)) != null) {
            return temp;
        }
        return arg1;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

