/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;
import org.matheclipse.core.reflection.system.Log;

public class Times
extends AbstractArgMultiple
implements INumeric {
    public static final Times CONST = new Times();
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher();

    @Override
    public HashedOrderlessMatcher getHashRuleMap() {
        return ORDERLESS_MATCHER;
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return c0.multiply(c1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return d0.multiply(d1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return d0.multiply(d1);
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return f0.multiply(f1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return i0.multiply(i1);
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        IAST f1;
        IAST f0;
        IAST f12;
        IExpr temp = null;
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (o0.isZero()) {
            if (o1.isDirectedInfinity()) {
                return F.Indeterminate;
            }
            return F.C0;
        }
        if (o1.isZero()) {
            if (o0.isDirectedInfinity()) {
                return F.Indeterminate;
            }
            return F.C0;
        }
        if (o0.isOne()) {
            return o1;
        }
        if (o1.isOne()) {
            return o0;
        }
        if (o0.equals(o1)) {
            return F.Power(o0, F.C2);
        }
        if (o0.isInfinity() || o0.isNegativeInfinity()) {
            temp = this.eInfinity(o0, o1);
        } else if (o1.isInfinity() || o1.isNegativeInfinity()) {
            temp = this.eInfinity(o1, o0);
        }
        if (temp != null) {
            return temp;
        }
        if (o0.isSymbol()) {
            ISymbol s0 = (ISymbol)o0;
            if (o1.isPower() && (f12 = (IAST)o1).arg2().isNumber() && s0.equals(f12.arg1())) {
                return F.Power((IExpr)s0, F.Plus((IExpr)F.C1, f12.arg2()));
            }
        }
        if (o0.isPower() && (f0 = (IAST)o0).arg2().isNumber()) {
            if (f0.equalsAt(1, o1)) {
                return F.Power(o1, F.Plus((IExpr)F.C1, f0.arg2()));
            }
            if (o1.isPower() && (f12 = (IAST)o1).arg2().isNumber()) {
                if (f0.equalsAt(1, f12.arg1())) {
                    return F.Power(f0.arg1(), F.Plus(f0.arg2(), f12.arg2()));
                }
                if (f0.equalsAt(2, f12.arg2()) && f0.arg1().isPositive() && f12.arg1().isPositive() && f0.arg1().isSignedNumber() && f12.arg1().isSignedNumber()) {
                    return F.Power((IExpr)F.Times(f0.arg1(), f12.arg1()), f0.arg2());
                }
            }
        }
        if (o1.isPower() && ((IAST)o1).arg2().isInteger() && (f1 = (IAST)o1).equalsAt(1, o0)) {
            return F.Power(o0, F.Plus((IExpr)F.C1, f1.arg2()));
        }
        if (o0.isInteger() && o1.isPlus() && ((IAST)o1).size() == 3 && ((IAST)o1).arg1().isNumericFunction()) {
            f1 = (IAST)o1;
            return f1.mapAt(F.Times(o0, null), 2);
        }
        return null;
    }

    private IExpr eInfinity(IExpr inf, IExpr o1) {
        if (inf.equals(F.CInfinity)) {
            if (o1.equals(F.CInfinity)) {
                return F.CInfinity;
            }
            if (o1.equals(F.CNInfinity)) {
                return F.CNInfinity;
            }
            if (o1.isSignedNumber()) {
                if (((ISignedNumber)o1).isNegative()) {
                    return F.CNInfinity;
                }
                return F.CInfinity;
            }
        } else if (inf.equals(F.CNInfinity)) {
            if (o1.equals(F.CInfinity)) {
                return F.CNInfinity;
            }
            if (o1.equals(F.CNInfinity)) {
                return F.CInfinity;
            }
            if (o1.isSignedNumber()) {
                if (((ISignedNumber)o1).isNegative()) {
                    return F.CInfinity;
                }
                return F.CNInfinity;
            }
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return c0.multiply(F.complex(i1, F.C0));
    }

    @Override
    public IExpr evaluate(IAST ast) {
        IAST temp;
        if (ast.size() > 2 && (temp = this.evaluateHashs(ast)) != null) {
            return temp;
        }
        if (ast.size() == 3) {
            if ((ast.arg1().isNumeric() || ast.arg1().isOne() || ast.arg1().isMinusOne()) && ast.arg2().isPlus()) {
                IAST arg2 = (IAST)ast.arg2();
                return arg2.mapAt(F.Times(ast.arg1(), null), 2);
            }
            return this.binaryOperator(ast.arg1(), ast.arg2());
        }
        if (ast.size() > 3) {
            ISymbol sym = ast.topHead();
            IAST result = F.ast(sym);
            IExpr temp2 = ast.arg1();
            boolean evaled = false;
            int i = 2;
            while (i < ast.size()) {
                IExpr tres = this.binaryOperator(temp2, (IExpr)ast.get(i));
                if (tres == null) {
                    for (int j = i + 1; j < ast.size(); ++j) {
                        tres = this.binaryOperator(temp2, (IExpr)ast.get(j));
                        if (tres == null) continue;
                        evaled = true;
                        temp2 = tres;
                        ast.remove(j);
                        break;
                    }
                    if (tres != null) continue;
                    result.add(temp2);
                    if (i == ast.size() - 1) {
                        result.add(ast.get(i));
                    } else {
                        temp2 = (IExpr)ast.get(i);
                    }
                    ++i;
                    continue;
                }
                evaled = true;
                temp2 = tres;
                if (i == ast.size() - 1) {
                    result.add(temp2);
                }
                ++i;
            }
            if (evaled) {
                if ((sym.getAttributes() & 1) == 1 && result.size() > 1) {
                    return result.getOneIdentity(F.C0);
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1165);
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Log(F.$p(F.x)), (IExpr)F.Power((IExpr)F.Log(F.$p(F.y)), F.CN1), Log.getFunction());
        super.setUp(symbol);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        double result = 1.0;
        for (int i = top - size + 1; i < top + 1; ++i) {
            result *= stack[i];
        }
        return result;
    }
}

