/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Thread
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IAST list;
        Validate.checkRange(ast, 2, 3);
        if (!ast.arg1().isAST()) {
            return null;
        }
        IExpr head = F.List;
        if (ast.size() == 3) {
            head = ast.arg2();
        }
        if ((list = (IAST)ast.arg1()).size() > 1) {
            return Thread.threadList(list, head, list.head(), 1);
        }
        return null;
    }

    public static IAST threadList(IAST list, IExpr head, IExpr mapHead, int headOffset) {
        int listLength = 0;
        for (int i = 1; i < list.size(); ++i) {
            if (!((IExpr)list.get(i)).isAST() || !((IAST)list.get(i)).head().equals(head)) continue;
            if (listLength == 0) {
                listLength = ((IAST)list.get(i)).size() - 1;
                continue;
            }
            if (listLength == ((IAST)list.get(i)).size() - 1) continue;
            listLength = 0;
            return null;
        }
        IAST result = F.ast(head, listLength, true);
        for (int j = headOffset; j < listLength + headOffset; ++j) {
            IAST subResult = F.ast(mapHead, list.size() - headOffset, true);
            for (int i = headOffset; i < list.size(); ++i) {
                if (((IExpr)list.get(i)).isAST() && ((IAST)list.get(i)).head().equals(head)) {
                    IAST arg = (IAST)list.get(i);
                    subResult.set(i, arg.get(j));
                    continue;
                }
                subResult.set(i, list.get(i));
            }
            result.set(j, subResult);
        }
        return result;
    }
}

