/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.eval.util.TableGenerator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryArrayFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Table
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        return Table.evaluateTable(ast, F.List(), F.List());
    }

    protected static IExpr evaluateTable(IAST ast, IAST resultList, IExpr defaultValue) {
        try {
            EvalEngine engine = EvalEngine.get();
            ArrayList<Iterator> iterList = new ArrayList<Iterator>();
            for (int i = 2; i < ast.size(); ++i) {
                iterList.add(new Iterator((IAST)ast.get(i), engine));
            }
            TableGenerator generator = new TableGenerator(iterList, resultList, new UnaryArrayFunction(engine, ast.arg1()), defaultValue);
            return generator.table();
        }
        catch (ClassCastException e) {
        }
        catch (NoEvalException noEvalException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

