/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.SincRules;
import org.matheclipse.parser.client.SyntaxError;

public class Sinc
extends AbstractTrigArg1
implements INumeric,
SincRules {
    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        double a1 = stack[top];
        if (a1 == 0.0) {
            return 1.0;
        }
        return Math.sin(a1) / a1;
    }

    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Sinc(negExpr);
        }
        return null;
    }

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e1DblArg(double arg1) {
        if (arg1 == 0.0) {
            return F.CD1;
        }
        return F.num(Math.sin(arg1) / arg1);
    }

    @Override
    public IExpr e1ApfloatArg(Apfloat arg1) {
        if (arg1.equals(Apfloat.ZERO)) {
            return F.num(Apfloat.ONE);
        }
        return F.num(ApfloatMath.sin(arg1).divide(arg1));
    }

    @Override
    public IExpr e1ApcomplexArg(Apcomplex arg1) {
        if (arg1.equals(Apcomplex.ZERO)) {
            return F.num(Apcomplex.ONE);
        }
        return F.complexNum(ApcomplexMath.sin(arg1).divide(arg1));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

