/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISymbol;

public class SignCmp
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        INumber number = NumericQ.getNumberNumericQ(arg1);
        if (number != null) {
            int signum = number.complexSign();
            return F.integer(signum);
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

