/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Sign
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        INumber number = NumericQ.getNumberNumericQ(arg1);
        if (number != null) {
            return this.numberSign(number);
        }
        return null;
    }

    public IExpr numberSign(INumber arg1) {
        if (arg1.isSignedNumber()) {
            int signum = ((ISignedNumber)arg1).sign();
            return F.integer(signum);
        }
        if (arg1.isComplex()) {
            IComplex c = (IComplex)arg1;
            return F.Times((IExpr)c, (IExpr)F.Power(c.eabs(), F.CN1));
        }
        if (arg1.isComplexNumeric()) {
            IComplexNum c = (IComplexNum)arg1;
            return c.divide(F.num(c.dabs()));
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

