/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.RingFactory;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.WrappedException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.QuarticSolver;
import org.matheclipse.core.reflection.system.CoefficientList;
import org.matheclipse.core.reflection.system.Factor;
import org.matheclipse.core.reflection.system.Together;

public class Roots
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            return null;
        }
        return Roots.roots(ast, false);
    }

    protected static IAST roots(IAST ast, boolean numericSolutions) {
        ExprVariables eVar = new ExprVariables(ast.arg1());
        if (!eVar.isSize(1)) {
            return null;
        }
        IExpr expr = F.evalExpandAll(ast.arg1());
        IAST variables = eVar.getVarList();
        IExpr denom = F.C1;
        if (expr.isAST() && !(denom = F.eval(F.Denominator(expr = Together.together((IAST)expr)))).isOne()) {
            expr = F.eval(F.Numerator(expr));
        }
        return Roots.rootsOfVariable(expr, denom, variables, numericSolutions);
    }

    public static IAST findRoots(double ... coefficients) {
        int i;
        int N2 = coefficients.length - 1;
        Array2DRowRealMatrix c = new Array2DRowRealMatrix(N2, N2);
        double a = coefficients[N2];
        for (i = 0; i < N2; ++i) {
            c.setEntry(i, N2 - 1, -coefficients[i] / a);
        }
        for (i = 1; i < N2; ++i) {
            c.setEntry(i, i - 1, 1.0);
        }
        try {
            IAST roots = F.List();
            EigenDecomposition ed = new EigenDecomposition(c);
            double[] realValues = ed.getRealEigenvalues();
            double[] imagValues = ed.getImagEigenvalues();
            for (int i2 = 0; i2 < N2; ++i2) {
                roots.add(F.chopExpr(F.complexNum(realValues[i2], imagValues[i2]), 1.0E-5));
            }
            return roots;
        }
        catch (Exception ime) {
            throw new WrappedException(ime);
        }
    }

    protected static IAST rootsOfVariable(IExpr expr, IExpr denom, IAST variables, boolean numericSolutions) {
        IAST result = null;
        ASTRange r = new ASTRange(variables, 1);
        List<IExpr> varList = r.toList();
        try {
            result = F.List();
            IAST factors = Factor.factorComplex(expr, varList, F.List, true, numericSolutions);
            for (int i = 1; i < factors.size(); ++i) {
                IExpr temp = F.evalExpand((IExpr)factors.get(i));
                IAST quarticResultList = QuarticSolver.solve(temp, variables.arg1());
                if (quarticResultList != null) {
                    for (int j = 1; j < quarticResultList.size(); ++j) {
                        if (numericSolutions) {
                            result.add(F.chopExpr(F.evaln((IExpr)quarticResultList.get(j)), 1.0E-5));
                            continue;
                        }
                        result.add(quarticResultList.get(j));
                    }
                    continue;
                }
                double[] coefficients = CoefficientList.coefficientList(temp, (ISymbol)variables.arg1());
                if (coefficients == null) {
                    return null;
                }
                IAST resultList = Roots.findRoots(coefficients);
                if (resultList == null || resultList.size() <= 0) continue;
                result.addAll(resultList);
            }
            result = QuarticSolver.createSet(result);
            return result;
        }
        catch (JASConversionException e) {
            try {
                JASIExpr eJas = new JASIExpr(varList, (RingFactory<IExpr>)new ExprRingFactory());
                GenPolynomial<IExpr> ePoly = eJas.expr2IExprJAS(expr);
                result = Roots.rootsOfPolynomial(ePoly);
                if (result != null && expr.isNumericMode()) {
                    for (int i = 1; i < result.size(); ++i) {
                        result.set(i, F.chopExpr((IExpr)result.get(i), 1.0E-5));
                    }
                }
            }
            catch (JASConversionException e2) {
                e2.printStackTrace();
            }
            if (result != null) {
                if (!denom.isNumber()) {
                    int i = 1;
                    while (i < result.size()) {
                        IExpr temp = denom.replaceAll(F.Rule(variables.arg1(), (IExpr)result.get(i)));
                        if (temp != null && F.eval(temp).isZero()) {
                            result.remove(i);
                            continue;
                        }
                        ++i;
                    }
                }
                return result;
            }
            return null;
        }
    }

    private static IAST rootsOfPolynomial(GenPolynomial<IExpr> ePoly) {
        long varDegree = ePoly.degree(0);
        IAST result = F.List();
        if (ePoly.isConstant()) {
            return result;
        }
        if (varDegree <= 4L) {
            IExpr a = F.C0;
            IExpr b = F.C0;
            IExpr c = F.C0;
            IExpr d = F.C0;
            IExpr e = F.C0;
            for (Monomial<IExpr> monomial : ePoly) {
                IExpr coeff = monomial.coefficient();
                long lExp = monomial.exponent().getVal(0);
                if (lExp == 4L) {
                    a = coeff;
                    continue;
                }
                if (lExp == 3L) {
                    b = coeff;
                    continue;
                }
                if (lExp == 2L) {
                    c = coeff;
                    continue;
                }
                if (lExp == 1L) {
                    d = coeff;
                    continue;
                }
                if (lExp == 0L) {
                    e = coeff;
                    continue;
                }
                throw new ArithmeticException("Roots::Unexpected exponent value: " + lExp);
            }
            result = QuarticSolver.quarticSolve(a, b, c, d, e);
            if (result != null) {
                result = QuarticSolver.createSet(result);
                return result;
            }
        }
        return null;
    }
}

