/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.Polynomial;
import org.matheclipse.parser.client.SyntaxError;

public class Resultant
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        ISymbol arg3;
        Validate.checkSize(ast, 4);
        ISymbol x = arg3 = Validate.checkSymbolType(ast, 3);
        IExpr a = F.evalExpandAll(ast.arg1());
        IExpr b = F.evalExpandAll(ast.arg2());
        Polynomial aPolynomial = new Polynomial(a, x, false);
        if (!aPolynomial.createPolynomial(a, true, false)) {
            throw new WrongArgumentType(ast, a, 1, "Polynomial expected!");
        }
        Polynomial bPolynomial = new Polynomial(b, x, false);
        if (!bPolynomial.createPolynomial(b, true, false)) {
            throw new WrongArgumentType(ast, b, 2, "Polynomial expected!");
        }
        return F.Together(this.resultant(a, b, x));
    }

    public IExpr resultant(IExpr a, IExpr b, ISymbol x) {
        IExpr r;
        IExpr aExp = F.eval(F.Exponent(a, x));
        IExpr bExp = F.eval(F.Exponent(b, x));
        if (b.isFree(x)) {
            return F.Power(b, aExp);
        }
        IExpr abExp = aExp.times(bExp);
        if (F.evalTrue(F.Less(aExp, bExp))) {
            return F.Times((IExpr)F.Power((IExpr)F.CN1, abExp), this.resultant(b, a, x));
        }
        IExpr rExp = r = F.eval(F.PolynomialRemainder(a, b, x));
        if (!r.isZero()) {
            rExp = F.eval(F.Exponent(r, x));
        }
        return F.Times(F.Power((IExpr)F.CN1, abExp), F.Power((IExpr)F.Coefficient(b, x, bExp), F.Subtract(aExp, rExp)), this.resultant(b, r, x));
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

