/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Re
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IAST astPower;
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        if (arg1.isNumber()) {
            return ((INumber)arg1).getRe();
        }
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Re(negExpr));
        }
        if (arg1.isTimes()) {
            if (arg1.getAt(1).isSignedNumber()) {
                IAST temp = ((IAST)arg1).removeAtClone(1);
                return F.Times(arg1.getAt(1), (IExpr)F.Re(temp));
            }
            if (arg1.getAt(1).equals(F.CI)) {
                IAST temp = ((IAST)arg1).removeAtClone(1);
                return F.Times((IExpr)F.CN1, (IExpr)F.Im(temp));
            }
        }
        if (arg1.isPlus()) {
            return ((IAST)arg1).mapAt(F.Re(null), 1);
        }
        if (arg1.isPower() && (astPower = (IAST)arg1).arg1().isRealFunction()) {
            IExpr x = astPower.arg1();
            if (((IExpr)astPower.get(2)).isNumber()) {
                ISignedNumber a = ((INumber)astPower.get(2)).getRe();
                ISignedNumber b = ((INumber)astPower.get(2)).getIm();
                return this.rePowerComplex(x, a, b);
            }
            IExpr a = F.eval(F.Re((IExpr)astPower.get(2)));
            IExpr b = F.eval(F.Im((IExpr)astPower.get(2)));
            return this.rePowerComplex(x, a, b);
        }
        return null;
    }

    private IExpr rePowerComplex(IExpr x, IExpr a, IExpr b) {
        if (x.isE()) {
            return F.Times((IExpr)F.Power((IExpr)F.E, a), (IExpr)F.Cos(b));
        }
        return F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Power(x, F.C2), F.Times((IExpr)F.C1D2, a)), (IExpr)F.Power((IExpr)F.E, F.Times((IExpr)F.Times((IExpr)F.CN1, b), (IExpr)F.Arg(x)))), (IExpr)F.Cos(F.Plus((IExpr)F.Times(a, (IExpr)F.Arg(x)), (IExpr)F.Times((IExpr)F.Times((IExpr)F.C1D2, b), (IExpr)F.Log(F.Power(x, F.C2))))));
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(128);
    }
}

