/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import java.util.Random;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;

public class RandomInteger
extends AbstractFunctionEvaluator {
    private static final Random RANDOM = new Random();

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        if (ast.arg1().isInteger()) {
            BigInteger r;
            BigInteger n = ((IInteger)ast.arg1()).getBigNumerator();
            while ((r = new BigInteger(n.bitLength(), RANDOM)).compareTo(n) >= 0) {
            }
            return F.integer(r);
        }
        return null;
    }
}

