/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.NoEvalException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Iterator;
import org.matheclipse.core.eval.util.TableGenerator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.UnaryArrayFunction;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class Product
extends AbstractFunctionEvaluator {
    public static final IAST RULES = F.List(F.ISetDelayed(F.Product(F.x_Symbol, F.List(F.x_, F.C0, F.m_)), F.C0), F.ISetDelayed(F.Product(F.x_Symbol, F.List(F.x_, F.C0, F.m_, F.s_)), F.C0), F.ISetDelayed(F.Product(F.x_Symbol, F.List(F.x_, F.C1, F.m_)), F.Condition(F.Factorial(F.m), F.FreeQ(F.x, F.m))));

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        IAST resultList;
        IExpr temp;
        IAST list;
        Validate.checkRange(ast, 3);
        if (ast.arg1().isTimes()) {
            IAST prod = ast.setAtClone(1, null);
            return ((IAST)ast.arg1()).mapAt(prod, 1);
        }
        if (ast.arg1().isPower()) {
            IExpr powArg1 = ast.arg1().getAt(1);
            IExpr powArg2 = ast.arg1().getAt(2);
            boolean flag = true;
            for (int i = 2; i < ast.size(); ++i) {
                IAST list2;
                if (((IExpr)ast.get(i)).isList() && (((IAST)ast.get(i)).size() == 4 || ((IAST)ast.get(i)).size() == 5) && powArg2.isFree((list2 = (IAST)ast.get(i)).arg1(), true)) continue;
                flag = false;
                break;
            }
            if (flag) {
                IAST prod = ast.clone();
                prod.set(1, powArg1);
                return F.Power((IExpr)prod, powArg2);
            }
        }
        if (ast.size() == 3 && ast.arg2().isList() && ((IAST)ast.arg2()).size() == 4 && (list = (IAST)ast.arg2()).arg1().isSymbol() && list.arg2().isInteger() && list.arg3().isSymbol()) {
            ISymbol var = (ISymbol)list.arg1();
            IInteger from = (IInteger)list.arg2();
            ISymbol to = (ISymbol)list.arg3();
            if (ast.isFreeAt(1, var) && ast.isFreeAt(1, to)) {
                if (from.equals(F.C1)) {
                    return F.Power(ast.arg1(), to);
                }
                if (from.equals(F.C0)) {
                    return F.Power(ast.arg1(), F.Plus((IExpr)to, (IExpr)F.C1));
                }
            }
        }
        if ((temp = Product.evaluateTable(ast, resultList = F.Times(), F.C0)) == null || temp.equals(resultList)) {
            return null;
        }
        return temp;
    }

    protected static IExpr evaluateTable(IAST ast, IAST resultList, IExpr defaultValue) {
        try {
            EvalEngine engine = EvalEngine.get();
            ArrayList<Iterator> iterList = new ArrayList<Iterator>();
            for (int i = 2; i < ast.size(); ++i) {
                iterList.add(new Iterator((IAST)ast.get(i), engine));
            }
            TableGenerator generator = new TableGenerator(iterList, resultList, new UnaryArrayFunction(engine, ast.arg1()), defaultValue);
            return generator.table();
        }
        catch (ClassCastException e) {
        }
        catch (NoEvalException noEvalException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

