/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.PowerRules;

public class Power
extends AbstractArg2
implements INumeric,
PowerRules {
    public static final Power CONST = new Power();

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e2ApcomplexArg(ApcomplexNum ac0, ApcomplexNum ac1) {
        return ac0.pow(ac1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum c0, IComplexNum c1) {
        return c0.pow(c1);
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return null;
    }

    @Override
    public IExpr e2ApfloatArg(ApfloatNum af0, ApfloatNum af1) {
        return af0.pow(af1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        if (d1.isMinusOne()) {
            return d0.inverse();
        }
        if (d1.isNumIntValue()) {
            return d0.pow(d1);
        }
        if (d0.isNegative()) {
            return F.complexNum(d0.doubleValue()).pow(F.complexNum(d1.doubleValue()));
        }
        return d0.pow(d1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        if (i0.equals(F.C0)) {
            return null;
        }
        if (i1.isNegative()) {
            return F.fraction(F.C1, i0.pow(((IInteger)i1.negate()).getBigNumerator().intValue()));
        }
        return i0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public IExpr e2ObjArg(IExpr arg1, IExpr arg2) {
        if (arg1.equals(F.Indeterminate) || arg2.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (arg2.isInfinity() || arg2.isNegativeInfinity()) {
            IExpr a1 = arg1;
            if (arg1.isNegative()) {
                a1 = ((ISignedNumber)a1).negate();
            }
            if (a1.isOne() || arg1.equals(F.CI) || arg1.equals(F.CNI)) {
                return F.Indeterminate;
            }
            if (arg1.isNumber()) {
                if (arg1.isSignedNumber() && (arg2.isInfinity() ? ((ISignedNumber)arg1).isGreaterThan(F.C1) : ((ISignedNumber)arg1).isLessThan(F.C1))) {
                    return F.CInfinity;
                }
                int comp = ((INumber)arg1).compareAbsValueToOne();
                switch (comp) {
                    case -1: {
                        if (arg2.isInfinity()) {
                            return F.C0;
                        }
                        return F.CComplexInfinity;
                    }
                    case 1: {
                        if (arg2.isInfinity()) {
                            return F.CComplexInfinity;
                        }
                        return F.C0;
                    }
                }
            }
            if (arg2.isInfinity() || arg2.isNegativeInfinity()) {
                // empty if block
            }
        }
        if (arg1.isZero()) {
            EvalEngine ee = EvalEngine.get();
            if (arg2.isZero()) {
                if (!ee.isQuietMode()) {
                    ee.getOutPrintStream().println("Infinite expression 0^0");
                }
                return F.Indeterminate;
            }
            if (arg2.isSignedNumber() && ((ISignedNumber)arg2).isNegative()) {
                if (!ee.isQuietMode()) {
                    ee.getOutPrintStream().println("Infinite expression 0^(negative number)");
                }
                return F.CComplexInfinity;
            }
            return F.C0;
        }
        if (arg2.isZero()) {
            if (arg1.isInfinity() || arg1.isNegativeInfinity()) {
                return F.Indeterminate;
            }
            return F.C1;
        }
        if (arg2.isOne()) {
            return arg1;
        }
        if (arg1.isOne()) {
            return F.C1;
        }
        if (arg2.isSignedNumber()) {
            ISignedNumber is1 = (ISignedNumber)arg2;
            if (arg1.isInfinity()) {
                if (is1.isNegative()) {
                    return F.C0;
                }
                return F.CInfinity;
            }
            if (arg1.isPower() && is1.isNumIntValue() && is1.isPositive()) {
                IAST a0 = (IAST)arg1;
                if (a0.arg2().isNumIntValue() && a0.arg2().isPositive()) {
                    return F.Power(a0.arg1(), is1.times(a0.arg2()));
                }
            } else if (arg1.isNegativeInfinity() && arg2.isInteger()) {
                IInteger ii = (IInteger)arg2;
                if (ii.isNegative()) {
                    return F.C0;
                }
                if (ii.isOdd()) {
                    return F.CNInfinity;
                }
                return F.CInfinity;
            }
        }
        if (arg2.isMinusOne() && arg1.isNumber()) {
            return ((INumber)arg1).inverse();
        }
        if (arg1.isSignedNumber() && ((ISignedNumber)arg1).isNegative() && arg2.equals(F.C1D2)) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)F.Times((IExpr)F.CN1, arg1), arg2));
        }
        if (arg1.isAST()) {
            IAST arg0 = (IAST)arg1;
            if (arg0.isTimes()) {
                IAST f0;
                if (arg2.isInteger()) {
                    return arg0.mapAt(F.Power(null, arg2), 1);
                }
                if (arg2.isNumber() && (f0 = arg0).size() > 1 && f0.arg1().isNumber()) {
                    return F.Times((IExpr)F.Power(f0.arg1(), arg2), (IExpr)F.Power((IExpr)F.ast(f0, F.Times, true, 2, f0.size()), arg2));
                }
            }
            if (arg0.isPower() && arg2.isInteger()) {
                return F.Power(arg0.arg1(), F.Times(arg2, arg0.arg2()));
            }
        }
        return null;
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        int iNumer;
        if (f0.getNumerator().equals(F.C0)) {
            return F.C0;
        }
        if (f1.getNumerator().equals(F.C0)) {
            return F.C1;
        }
        if (f1.equals(F.C1D2) && f0.isNegative()) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)f0.negate(), f1));
        }
        if (f1.equals(F.CN1D2) && f0.isNegative()) {
            return F.Times(F.CN1, F.CI, F.Power((IExpr)f0.negate().inverse(), f1.negate()));
        }
        if (!f1.getDenominator().equals(F.C1)) {
            IInteger b;
            IInteger a;
            IFraction f0Temp = f0;
            if (f0.sign() < 0) {
                f0Temp = (IFraction)f0Temp.negate();
            }
            if (f1.isNegative()) {
                a = f0Temp.getDenominator();
                b = f0Temp.getNumerator();
            } else {
                a = f0Temp.getNumerator();
                b = f0Temp.getDenominator();
            }
            if (!f1.getNumerator().equals(F.C1)) {
                try {
                    int exp = f1.getNumerator().toInt();
                    if (exp < 0) {
                        exp *= -1;
                    }
                    a = a.pow(exp);
                    b = b.pow(exp);
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            IInteger root = f1.getDenominator();
            IInteger[] new_numer = this.calculateRoot(a, root);
            IInteger[] new_denom = this.calculateRoot(b, root);
            IFraction new_root = F.fraction(F.C1, root);
            if (new_numer != null) {
                if (new_denom != null) {
                    IRational p0 = null;
                    p0 = new_denom[1].equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], new_denom[1]);
                    if (f0.sign() < 0) {
                        return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                    }
                    return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
                }
                if (a.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = b.equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], b);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0, new_root));
            }
            if (new_denom != null) {
                if (b.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = new_denom[1].equals(F.C1) ? a : F.fraction(a, new_denom[1]);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
            }
            return null;
        }
        try {
            iNumer = f1.getNumerator().toInt();
        }
        catch (ArithmeticException iob) {
            return null;
        }
        return f0.pow(iNumer);
    }

    private IInteger[] calculateRoot(IInteger a, IInteger root) {
        try {
            int n = root.toInt();
            if (n > 0) {
                if (a.equals(F.C1)) {
                    return null;
                }
                if (a.equals(F.CN1)) {
                    return null;
                }
                IInteger[] result = a.nthRootSplit(n);
                if (result[1].equals(a)) {
                    return null;
                }
                return result;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        if (c0.isZero()) {
            return F.C0;
        }
        if (i1.isZero()) {
            return F.C1;
        }
        return c0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public IExpr eComFraArg(IComplex c0, IFraction i1) {
        if (i1.equals(F.C1D2) && c0.getRealPart().equals(BigFraction.ZERO)) {
            BigFraction im = c0.getImaginaryPart();
            boolean negative = false;
            if (NumberUtil.isNegative(im = im.divide(BigInteger.valueOf(2L)))) {
                im = im.negate();
                negative = true;
            }
            if (NumberUtil.isPerfectSquare(im)) {
                IAST temp = F.Sqrt(F.fraction(im));
                if (negative) {
                    return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CNI, (IExpr)temp));
                }
                return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CI, (IExpr)temp));
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 2) {
            throw new UnsupportedOperationException();
        }
        return Math.pow(stack[top - 1], stack[top]);
    }
}

