/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.PolynomialQuotientRemainder;

public class PolynomialRemainder
extends PolynomialQuotientRemainder {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 4, 5);
        ISymbol variable = Validate.checkSymbolType(ast, 3);
        IExpr arg1 = F.evalExpandAll(ast.arg1());
        IExpr arg2 = F.evalExpandAll(ast.arg2());
        if (ast.size() == 5) {
            Options options = new Options(ast.topHead(), ast, 4);
            IExpr option = options.getOption("Modulus");
            if (option != null && option.isSignedNumber()) {
                IExpr[] result = this.quotientRemainderModInteger(arg1, arg2, variable, option);
                if (result == null) {
                    return null;
                }
                return result[1];
            }
            return null;
        }
        IExpr[] result = PolynomialRemainder.quotientRemainder(arg1, arg2, variable);
        if (result == null) {
            return null;
        }
        return result[1];
    }
}

