/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingFactory;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ExprRingFactory;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class PolynomialQuotientRemainder
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 4, 5);
        ISymbol variable = Validate.checkSymbolType(ast, 3);
        IExpr arg1 = F.evalExpandAll(ast.arg1());
        IExpr arg2 = F.evalExpandAll(ast.arg2());
        if (ast.size() == 5) {
            Options options = new Options(ast.topHead(), ast, 4);
            IExpr option = options.getOption("Modulus");
            if (option != null && option.isSignedNumber()) {
                IExpr[] result = this.quotientRemainderModInteger(arg1, arg2, variable, option);
                if (result == null) {
                    return null;
                }
                IAST list = F.List();
                list.add(result[0]);
                list.add(result[1]);
                return list;
            }
            return null;
        }
        IExpr[] result = PolynomialQuotientRemainder.quotientRemainder(arg1, arg2, variable);
        if (result == null) {
            return null;
        }
        IAST list = F.List();
        list.add(result[0]);
        list.add(result[1]);
        return list;
    }

    public static IExpr[] quotientRemainder(IExpr arg1, IExpr arg2, ISymbol variable) {
        try {
            JASConvert<BigRational> jas = new JASConvert<BigRational>(variable, BigRational.ZERO);
            GenPolynomial<BigRational> poly1 = jas.expr2JAS(arg1, false);
            GenPolynomial<BigRational> poly2 = jas.expr2JAS(arg2, false);
            GenPolynomial<BigRational>[] divRem = poly1.quotientRemainder(poly2);
            IExpr[] result = new IExpr[]{jas.rationalPoly2Expr(divRem[0]), jas.rationalPoly2Expr(divRem[1])};
            return result;
        }
        catch (JASConversionException e1) {
            try {
                JASIExpr jas = new JASIExpr((IExpr)variable, (RingFactory<IExpr>)new ExprRingFactory());
                GenPolynomial<IExpr> poly1 = jas.expr2IExprJAS(arg1);
                GenPolynomial<IExpr> poly2 = jas.expr2IExprJAS(arg2);
                GenPolynomial<IExpr>[] divRem = poly1.quotientRemainder(poly2);
                IExpr[] result = new IExpr[]{jas.exprPoly2Expr(divRem[0], variable), jas.exprPoly2Expr(divRem[1], variable)};
                return result;
            }
            catch (JASConversionException e) {
                return null;
            }
        }
    }

    public IExpr[] quotientRemainderModInteger(IExpr arg1, IExpr arg2, ISymbol variable, IExpr option) {
        try {
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(variable, modIntegerRing);
            GenPolynomial<ModLong> poly1 = jas.expr2JAS(arg1);
            GenPolynomial<ModLong> poly2 = jas.expr2JAS(arg2);
            GenPolynomial<ModLong>[] divRem = poly1.quotientRemainder(poly2);
            IExpr[] result = new IExpr[]{jas.modLongPoly2Expr(divRem[0]), jas.modLongPoly2Expr(divRem[1])};
            return result;
        }
        catch (JASConversionException e) {
            return null;
        }
    }
}

