/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Factor;

public class PolynomialLCM
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Options options;
        IExpr option;
        Validate.checkRange(ast, 3);
        ExprVariables eVar = new ExprVariables(ast.arg1());
        for (int i = 2; i < ast.size(); ++i) {
            eVar.addVarList((IExpr)ast.get(i));
        }
        ASTRange r = new ASTRange(eVar.getVarList(), 1);
        IExpr expr = F.evalExpandAll(ast.arg1());
        if (ast.size() > 3 && (option = (options = new Options(ast.topHead(), ast, ast.size() - 1)).getOption("Modulus")) != null && option.isSignedNumber()) {
            try {
                ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                JASModInteger jas = new JASModInteger(r.toList(), modIntegerRing);
                GenPolynomial<ModLong> poly = jas.expr2JAS(expr);
                GreatestCommonDivisorAbstract<ModLong> factory = GCDFactory.getImplementation(modIntegerRing);
                for (int i = 2; i < ast.size() - 1; ++i) {
                    expr = F.evalExpandAll((IExpr)ast.get(i));
                    GenPolynomial<ModLong> temp = jas.expr2JAS(expr);
                    poly = factory.lcm(poly, temp);
                }
                return Factor.factorModulus(jas, modIntegerRing, poly.monic(), false);
            }
            catch (JASConversionException e) {
                return null;
            }
        }
        try {
            JASConvert<BigInteger> jas = new JASConvert<BigInteger>(r.toList(), BigInteger.ZERO);
            GenPolynomial<BigInteger> poly = jas.expr2JAS(expr, false);
            GreatestCommonDivisorAbstract<BigInteger> factory = GCDFactory.getImplementation(BigInteger.ZERO);
            for (int i = 2; i < ast.size(); ++i) {
                expr = F.evalExpandAll((IExpr)ast.get(i));
                GenPolynomial<BigInteger> temp = jas.expr2JAS(expr, false);
                poly = factory.lcm(poly, temp);
            }
            return jas.integerPoly2Expr(poly.monic());
        }
        catch (JASConversionException e) {
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

