/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.HashMap;
import java.util.Map;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.AST;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.HashedOrderlessMatcher;

public class Plus
extends AbstractArgMultiple
implements INumeric {
    public static final Plus CONST = new Plus();
    private static HashedOrderlessMatcher ORDERLESS_MATCHER = new HashedOrderlessMatcher();

    @Override
    public HashedOrderlessMatcher getHashRuleMap() {
        return ORDERLESS_MATCHER;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        IAST temp;
        int size = ast.size();
        if (ast.isEvalFlagOff(2048)) {
            if (size > 2) {
                boolean evaled = false;
                HashMap<IExpr, IExpr> plusMap = new HashMap<IExpr, IExpr>(size + 5 + size / 10);
                IExpr numberValue = null;
                for (int i = 1; i < size; ++i) {
                    if (((IExpr)ast.get(i)).isIndeterminate()) {
                        return F.Indeterminate;
                    }
                    if (((IExpr)ast.get(i)).isInfinity()) {
                        if (numberValue == null) {
                            numberValue = (IExpr)ast.get(i);
                            continue;
                        }
                        if (!(numberValue = this.infinityPlus(numberValue)).isIndeterminate()) continue;
                        return F.Indeterminate;
                    }
                    if (((IExpr)ast.get(i)).isNegativeInfinity()) {
                        if (numberValue == null) {
                            numberValue = (IExpr)ast.get(i);
                            continue;
                        }
                        if (!(numberValue = this.negativeInfinityPlus(numberValue)).isIndeterminate()) continue;
                        return F.Indeterminate;
                    }
                    if (((IExpr)ast.get(i)).isNumber()) {
                        if (((IExpr)ast.get(i)).isZero()) {
                            evaled = true;
                            continue;
                        }
                        if (numberValue == null) {
                            numberValue = (IExpr)ast.get(i);
                            continue;
                        }
                        if (numberValue.isNumber()) {
                            numberValue = numberValue.plus((IExpr)ast.get(i));
                            evaled = true;
                            continue;
                        }
                        if (numberValue.isInfinity()) {
                            numberValue = this.infinityPlus((IExpr)ast.get(i));
                            if (numberValue.isIndeterminate()) {
                                return F.Indeterminate;
                            }
                            evaled = true;
                            continue;
                        }
                        if (!numberValue.isNegativeInfinity()) continue;
                        numberValue = this.negativeInfinityPlus((IExpr)ast.get(i));
                        if (numberValue.isIndeterminate()) {
                            return F.Indeterminate;
                        }
                        evaled = true;
                        continue;
                    }
                    if (((IExpr)ast.get(i)).isTimes()) {
                        IAST timesAST = (IAST)ast.get(i);
                        if (timesAST.arg1().isNumber()) {
                            if (!this.addMerge(plusMap, timesAST.removeAtClone(1).getOneIdentity(F.C1), timesAST.arg1())) continue;
                            evaled = true;
                            continue;
                        }
                        if (!this.addMerge(plusMap, timesAST, F.C1)) continue;
                        evaled = true;
                        continue;
                    }
                    if (!this.addMerge(plusMap, (IExpr)ast.get(i), F.C1)) continue;
                    evaled = true;
                }
                if (evaled) {
                    IAST result = F.Plus();
                    if (numberValue != null) {
                        result.add(numberValue);
                    }
                    for (Map.Entry element : plusMap.entrySet()) {
                        if (((IExpr)element.getValue()).isOne()) {
                            IExpr temp2 = (IExpr)element.getKey();
                            if (temp2.isPlus()) {
                                result.addAll((IAST)temp2);
                                continue;
                            }
                            result.add(temp2);
                            continue;
                        }
                        result.add(F.Times((IExpr)element.getValue(), (IExpr)element.getKey()));
                    }
                    result.addEvalFlags(2048);
                    return result.getOneIdentity(F.C0);
                }
            }
            ast.addEvalFlags(2048);
        }
        if (size > 2 && (temp = this.evaluateHashs(ast)) != null) {
            return temp;
        }
        return null;
    }

    public boolean addMerge(Map<IExpr, IExpr> plusMap, IExpr key, IExpr value) {
        IExpr temp = plusMap.get(key);
        if (temp == null) {
            plusMap.put(key, value);
            return false;
        }
        if (temp.isNumber() && value.isNumber()) {
            if ((temp = temp.plus(value)).isZero()) {
                plusMap.remove(key);
            }
        } else if (temp.head().equals(F.Plus)) {
            ((IAST)temp).add(value);
        } else {
            temp = F.Plus(temp, value);
        }
        plusMap.put(key, temp);
        return true;
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return c0.add(c1);
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
        return d0.add(d1);
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        return f0.add(f1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        return i0.add(i1);
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        IAST f1;
        if (o0.isZero()) {
            return o1;
        }
        if (o1.isZero()) {
            return o0;
        }
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        IExpr temp = null;
        if (o0.isInfinity() || o0.isNegativeInfinity()) {
            temp = this.eInfinity(o0, o1);
        } else if (o1.isInfinity() || o1.isNegativeInfinity()) {
            temp = this.eInfinity(o1, o0);
        }
        if (temp != null) {
            return temp;
        }
        if (o0.equals(o1)) {
            return F.Times((IExpr)F.C2, o0);
        }
        if (o0.isTimes()) {
            AST f12;
            AST f0 = (AST)o0;
            if (f0.arg1().isNumber()) {
                if (f0.size() == 3 && f0.equalsAt(2, o1)) {
                    return f0.arg1().plus(F.C1).times(o1);
                }
                if (o1.isTimes()) {
                    AST f13 = (AST)o1;
                    if (f13.arg1().isNumber()) {
                        if (f0.equalsFromPosition(1, f13, 1)) {
                            IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                            return F.Times((IExpr)F.Plus(f0.arg1(), f13.arg1()), (IExpr)result);
                        }
                    } else if (f0.equalsFromPosition(1, f13, 0)) {
                        IAST result = F.ast(f0, F.Times, true, 2, f0.size());
                        return F.Times(f0.arg1().plus(F.C1), (IExpr)result);
                    }
                }
            } else if (o1.isTimes() && (f12 = (AST)o1).arg1().isNumber() && f0.equalsFromPosition(0, f12, 1)) {
                IAST result = F.ast(f12, F.Times, true, 2, f12.size());
                return F.Times(f12.arg1().plus(F.C1), (IExpr)result);
            }
        }
        if (o1.isTimes() && ((IAST)o1).arg1().isNumber() && (f1 = (IAST)o1).size() == 3 && f1.equalsAt(2, o0)) {
            return f1.arg1().plus(F.C1).times(o0);
        }
        return null;
    }

    private IExpr infinityPlus(IExpr o1) {
        if (o1.isInfinity()) {
            return F.CInfinity;
        }
        if (o1.isNegativeInfinity()) {
            EvalEngine engine = EvalEngine.get();
            if (!engine.isQuietMode()) {
                engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
            }
            return F.Indeterminate;
        }
        return F.CInfinity;
    }

    private IExpr negativeInfinityPlus(IExpr o1) {
        if (o1.isInfinity()) {
            EvalEngine engine = EvalEngine.get();
            if (!engine.isQuietMode()) {
                engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
            }
            return F.Indeterminate;
        }
        if (o1.isNegativeInfinity()) {
            return F.CNInfinity;
        }
        return F.CNInfinity;
    }

    private IExpr eInfinity(IExpr inf, IExpr o1) {
        EvalEngine engine = EvalEngine.get();
        if (inf.isInfinity()) {
            if (o1.isInfinity()) {
                return F.CInfinity;
            }
            if (o1.isNegativeInfinity()) {
                if (!engine.isQuietMode()) {
                    engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                }
                return F.Indeterminate;
            }
            return F.CInfinity;
        }
        if (inf.isNegativeInfinity()) {
            if (o1.isInfinity()) {
                if (!engine.isQuietMode()) {
                    engine.getOutPrintStream().println("Indeterminate expression Infinity-Infinity");
                }
                return F.Indeterminate;
            }
            if (o1.isNegativeInfinity()) {
                return F.CNInfinity;
            }
            return F.CNInfinity;
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        return c0.add(F.complex(i1, F.C0));
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1165);
        ORDERLESS_MATCHER.definePatternHashRule(F.Power((IExpr)F.Sin(F.x_), F.C2), F.Power((IExpr)F.Cos(F.x_), F.C2), F.C1);
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.Times((IExpr)F.a_, (IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2)), (IExpr)F.Times((IExpr)F.a_, (IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2)), F.a);
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.ArcSin(F.x_), (IExpr)F.ArcCos(F.x_), F.Times((IExpr)F.C1D2, (IExpr)F.Pi));
        ORDERLESS_MATCHER.defineHashRule((IExpr)F.ArcTan(F.x_), (IExpr)F.ArcCot(F.x_), F.Times((IExpr)F.C1D2, (IExpr)F.Pi));
        ORDERLESS_MATCHER.defineHashRule(F.ArcTan(F.x_), F.ArcTan(F.y_), F.Times((IExpr)F.C1D2, (IExpr)F.Pi), F.And(F.Positive(F.x), F.Equal((IExpr)F.y, (IExpr)F.Power((IExpr)F.x, F.CN1))));
        ORDERLESS_MATCHER.definePatternHashRule(F.Times((IExpr)F.CN1, (IExpr)F.ArcTan(F.x_)), F.Times((IExpr)F.CN1, (IExpr)F.ArcTan(F.y_)), F.Times((IExpr)F.CN1D2, (IExpr)F.Pi), F.And(F.Positive(F.x), F.Equal((IExpr)F.y, (IExpr)F.Power((IExpr)F.x, F.CN1))));
        ORDERLESS_MATCHER.definePatternHashRule(F.Power((IExpr)F.Cosh(F.x_), F.C2), F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sinh(F.x_), F.C2)), F.C1);
        super.setUp(symbol);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        double result = 0.0;
        for (int i = top - size + 1; i < top + 1; ++i) {
            result += stack[i];
        }
        return result;
    }
}

