/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.combinatoric.KPermutationsList;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Permutations
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        if (ast.arg1().isAST()) {
            IAST f = (IAST)ast.arg1();
            IAST result = F.ast(f.head());
            if (f.size() <= 2) {
                if (f.size() == 2) {
                    result.add(f);
                }
                return result;
            }
            int k = f.size() - 1;
            if (ast.size() == 3) {
                if (!ast.arg2().isInteger()) {
                    return null;
                }
                k = Validate.checkIntType(ast, 2);
                if (k > f.size() - 1) {
                    return null;
                }
            }
            KPermutationsList perm = new KPermutationsList(f, k, F.ast(f.head()), 1);
            for (IAST temp : perm) {
                result.add(temp);
            }
            return result;
        }
        return null;
    }
}

