/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class Outer
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 4);
        IExpr head = null;
        for (int i = 2; i < ast.size(); ++i) {
            IExpr list = (IExpr)ast.get(i);
            if (!list.isAST()) {
                return null;
            }
            if (head == null) {
                head = list.head();
                continue;
            }
            if (head.equals(list.head())) continue;
            return null;
        }
        OuterAlgorithm algorithm = new OuterAlgorithm(ast, head);
        return algorithm.outer(3, (IExpr)ast.get(2), F.ast(F.List, ast.size() - 1, false));
    }

    private static class OuterAlgorithm {
        final IAST ast;
        final IExpr f;
        final IExpr head;

        public OuterAlgorithm(IAST ast, IExpr head) {
            this.ast = ast;
            this.f = ast.arg1();
            this.head = head;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IAST outer(int astPosition, IExpr expr, IAST current) {
            if (expr.isAST() && this.head.equals(expr.head())) {
                IAST list = (IAST)expr;
                IAST result = F.ast(this.head);
                for (int i = 1; i < list.size(); ++i) {
                    IExpr temp = (IExpr)list.get(i);
                    result.add(this.outer(astPosition, temp, current));
                }
                return result;
            }
            if (this.ast.size() > astPosition) {
                try {
                    current.add(expr);
                    IAST list = this.outer(astPosition + 1, (IExpr)this.ast.get(astPosition), current);
                    return list;
                }
                finally {
                    current.remove(current.size() - 1);
                }
            }
            IAST result = F.ast(this.f);
            result.addAll(current);
            result.add(expr);
            return result;
        }
    }
}

