/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.PossibleZeroQ;
import org.matheclipse.core.reflection.system.Roots;
import org.matheclipse.core.reflection.system.Together;

public class NSolve
extends AbstractFunctionEvaluator {
    private static IAST analyzeSublist(ArrayList<ExprAnalyzer> analyzerList, IAST vars, IAST resultList, IAST matrix, IAST vector) throws NoSolution {
        Collections.sort(analyzerList);
        for (int currEquation = 0; currEquation < analyzerList.size(); ++currEquation) {
            ExprAnalyzer exprAnalyzer = analyzerList.get(currEquation);
            if (exprAnalyzer.getNumberOfVars() == 0) {
                IExpr expr = exprAnalyzer.getNumerator();
                if (expr.isZero()) continue;
                if (expr.isNumber()) {
                    throw new NoSolution(0);
                }
                if (PossibleZeroQ.possibleZeroQ(expr)) continue;
                throw new NoSolution(1);
            }
            if (exprAnalyzer.getNumberOfVars() == 1 && exprAnalyzer.isLinearOrPolynomial()) {
                IAST listOfRules = NSolve.rootsOfUnivariatePolynomial(exprAnalyzer);
                if (listOfRules != null) {
                    boolean evaled = false;
                    ++currEquation;
                    for (int k = 1; k < listOfRules.size(); ++k) {
                        if (currEquation >= analyzerList.size()) {
                            resultList.add(F.List((IExpr)listOfRules.getAST(k)));
                            evaled = true;
                            continue;
                        }
                        ArrayList<ExprAnalyzer> subAnalyzerList = new ArrayList<ExprAnalyzer>();
                        for (int i = currEquation; i < analyzerList.size(); ++i) {
                            IExpr expr = analyzerList.get(i).getExpr();
                            IExpr temp = expr.replaceAll(listOfRules.getAST(k));
                            if (temp != null) {
                                expr = F.eval(temp);
                                exprAnalyzer = new ExprAnalyzer(expr, vars);
                                exprAnalyzer.analyze();
                            } else {
                                exprAnalyzer = analyzerList.get(i);
                            }
                            subAnalyzerList.add(exprAnalyzer);
                        }
                        try {
                            IAST subResultList = NSolve.analyzeSublist(subAnalyzerList, vars, F.List(), matrix, vector);
                            if (subResultList == null) continue;
                            evaled = true;
                            for (IExpr expr : subResultList) {
                                if (expr.isList()) {
                                    IAST list = (IAST)expr;
                                    list.add(1, listOfRules.getAST(k));
                                    resultList.add(list);
                                    continue;
                                }
                                resultList.add(expr);
                            }
                            continue;
                        }
                        catch (NoSolution e) {
                            if (e.getType() != 0) continue;
                            evaled = true;
                        }
                    }
                    if (evaled) {
                        return resultList;
                    }
                }
                throw new NoSolution(1);
            }
            if (exprAnalyzer.isLinear()) {
                matrix.add(F.eval(exprAnalyzer.getRow()));
                vector.add(F.eval(F.Negate(exprAnalyzer.getValue())));
                continue;
            }
            throw new NoSolution(1);
        }
        return resultList;
    }

    private static IAST rootsOfUnivariatePolynomial(ExprAnalyzer exprAnalyzer) {
        IExpr expr = exprAnalyzer.getNumerator();
        IExpr denom = exprAnalyzer.getDenominator();
        for (ISymbol sym : exprAnalyzer.getSymbolSet()) {
            IAST temp = Roots.rootsOfVariable(expr, denom, F.List((IExpr)sym), true);
            if (temp == null) continue;
            IAST resultList = F.List();
            if (temp.isASTSizeGE(F.List, 2)) {
                IAST rootsList = temp;
                for (IExpr root : rootsList) {
                    IAST rule = F.Rule(sym, root);
                    resultList.add(rule);
                }
                return resultList;
            }
            return null;
        }
        return null;
    }

    private IAST checkEquations(IAST ast, int position) {
        IAST termsEqualZeroList = F.List();
        IAST eqns = null;
        if (((IExpr)ast.get(position)).isList()) {
            eqns = (IAST)ast.get(position);
            for (int i = 1; i < eqns.size(); ++i) {
                if (!((IExpr)eqns.get(i)).isAST(F.Equal, 3)) {
                    throw new WrongArgumentType(eqns, (IExpr)eqns.get(i), i, "Equal[] expression (a==b) expected");
                }
                IAST eq = (IAST)eqns.get(i);
                termsEqualZeroList.add(F.evalExpandAll(F.Subtract(eq.arg1(), eq.arg2())));
            }
        } else if (((IExpr)ast.get(position)).isAST(F.Equal, 3)) {
            IAST eq = (IAST)ast.get(position);
            termsEqualZeroList.add(F.evalExpandAll(F.Subtract(eq.arg1(), eq.arg2())));
        } else {
            throw new WrongArgumentType(ast, ast.arg1(), 1, "Equal[] expression (a==b) expected");
        }
        return termsEqualZeroList;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        IAST vars = Validate.checkSymbolOrSymbolList(ast, 2);
        IAST termsEqualZeroList = this.checkEquations(ast, 1);
        ArrayList<ExprAnalyzer> analyzerList = new ArrayList<ExprAnalyzer>();
        for (IExpr expr : termsEqualZeroList) {
            ExprAnalyzer exprAnalyzer = new ExprAnalyzer(expr, vars);
            exprAnalyzer.analyze();
            analyzerList.add(exprAnalyzer);
        }
        IAST matrix = F.List();
        IAST vector = F.List();
        try {
            IAST resultList = F.List();
            resultList = NSolve.analyzeSublist(analyzerList, vars, resultList, matrix, vector);
            if (vector.size() > 1) {
                IExpr temp = F.eval(F.LinearSolve(matrix, vector));
                if (temp.isASTSizeGE(F.List, 2)) {
                    IAST rootsList = (IAST)temp;
                    IAST list = F.List();
                    for (int j = 1; j < vars.size(); ++j) {
                        IAST rule = F.Rule((IExpr)vars.get(j), (IExpr)rootsList.get(j));
                        list.add(rule);
                    }
                    resultList.add(list);
                } else {
                    return null;
                }
            }
            return resultList;
        }
        catch (NoSolution e) {
            if (e.getType() == 0) {
                return F.List();
            }
            return null;
        }
    }

    private static class NoSolution
    extends Exception {
        public static final int NO_SOLUTION_FOUND = 1;
        public static final int WRONG_SOLUTION = 0;
        final int solType;

        public NoSolution(int solType) {
            this.solType = solType;
        }

        public int getType() {
            return this.solType;
        }
    }

    private static class ExprAnalyzer
    implements Comparable<ExprAnalyzer> {
        public static final int LINEAR = 0;
        public static final int OTHERS = 2;
        public static final int POLYNOMIAL = 1;
        private int equationType;
        private IExpr expr;
        private IExpr numer;
        private IExpr denom;
        private int leafCount;
        IAST row;
        HashSet<ISymbol> symbolSet;
        IAST value;
        final IAST vars;

        public ExprAnalyzer(IExpr expr, IAST vars) {
            this.expr = expr;
            this.numer = expr;
            this.denom = F.C1;
            if (this.expr.isAST()) {
                this.expr = Together.together((IAST)this.expr);
                this.denom = F.eval(F.Denominator(this.expr));
                if (!this.denom.isOne()) {
                    this.numer = F.eval(F.Numerator(this.expr));
                }
            }
            this.vars = vars;
            this.symbolSet = new HashSet();
            this.leafCount = 0;
            this.reset();
        }

        public void analyze() {
            this.analyze(this.getNumerator());
        }

        private void analyze(IExpr eqExpr) {
            if (eqExpr.isFree(Predicates.in(this.vars), true)) {
                ++this.leafCount;
                this.value.add(eqExpr);
            } else if (eqExpr.isPlus()) {
                ++this.leafCount;
                IAST arg = (IAST)eqExpr;
                for (int i = 1; i < arg.size(); ++i) {
                    IExpr expr = (IExpr)arg.get(i);
                    if (expr.isFree(Predicates.in(this.vars), true)) {
                        ++this.leafCount;
                        this.value.add(expr);
                        continue;
                    }
                    this.getPlusEquationType(expr);
                }
            } else {
                this.getPlusEquationType(eqExpr);
            }
        }

        @Override
        public int compareTo(ExprAnalyzer o) {
            if (this.symbolSet.size() != o.symbolSet.size()) {
                if (this.symbolSet.size() < o.symbolSet.size()) {
                    return -1;
                }
                return 1;
            }
            if (this.equationType != o.equationType) {
                if (this.equationType < o.equationType) {
                    return -1;
                }
                return 1;
            }
            if (this.leafCount != o.leafCount) {
                if (this.leafCount < o.leafCount) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        public IExpr getExpr() {
            return this.expr;
        }

        public IExpr getNumerator() {
            return this.numer;
        }

        public IExpr getDenominator() {
            return this.denom;
        }

        public int getNumberOfVars() {
            return this.symbolSet.size();
        }

        private void getPlusEquationType(IExpr eqExpr) {
            if (eqExpr.isTimes()) {
                ISymbol sym = null;
                ++this.leafCount;
                IAST arg = (IAST)eqExpr;
                for (int i = 1; i < arg.size(); ++i) {
                    IExpr expr = (IExpr)arg.get(i);
                    if (expr.isFree(Predicates.in(this.vars), true)) {
                        ++this.leafCount;
                        continue;
                    }
                    if (expr.isSymbol()) {
                        ++this.leafCount;
                        for (int j = 1; j < this.vars.size(); ++j) {
                            if (!((IExpr)this.vars.get(j)).equals(expr)) continue;
                            this.symbolSet.add((ISymbol)expr);
                            if (sym != null) {
                                if (this.equationType != 0) continue;
                                this.equationType = 1;
                                continue;
                            }
                            sym = (ISymbol)expr;
                            if (this.equationType != 0) continue;
                            IAST cloned = arg.removeAtClone(i);
                            this.row.set(j, F.Plus((IExpr)this.row.get(j), (IExpr)cloned));
                        }
                        continue;
                    }
                    if (expr.isPower() && (expr.getAt(2).isInteger() || expr.getAt(2).isNumIntValue())) {
                        if (this.equationType == 0) {
                            this.equationType = 1;
                        }
                        this.getTimesEquationType(((IAST)expr).arg1());
                        continue;
                    }
                    this.leafCount = (int)((long)this.leafCount + eqExpr.leafCount());
                    if (this.equationType > 1) continue;
                    this.equationType = 2;
                }
                if (this.equationType == 0 && sym == null) {
                    System.out.println("sym == null???");
                }
            } else {
                this.getTimesEquationType(eqExpr);
            }
        }

        public IAST getRow() {
            return this.row;
        }

        public HashSet<ISymbol> getSymbolSet() {
            return this.symbolSet;
        }

        private void getTimesEquationType(IExpr expr) {
            if (expr.isSymbol()) {
                ++this.leafCount;
                for (int i = 1; i < this.vars.size(); ++i) {
                    if (!this.vars.equalsAt(i, expr)) continue;
                    this.symbolSet.add((ISymbol)expr);
                    if (this.equationType != 0) continue;
                    this.row.set(i, F.Plus((IExpr)this.row.get(i), (IExpr)F.C1));
                }
                return;
            }
            if (expr.isFree(Predicates.in(this.vars), true)) {
                ++this.leafCount;
                this.value.add(expr);
                return;
            }
            if (expr.isPower()) {
                if (((IAST)expr).arg2().isInteger()) {
                    if (this.equationType == 0) {
                        this.equationType = 1;
                    }
                    this.getTimesEquationType(((IAST)expr).arg1());
                    return;
                }
                if (((IAST)expr).arg2().isNumIntValue()) {
                    if (this.equationType == 0) {
                        this.equationType = 1;
                    }
                    this.getTimesEquationType(((IAST)expr).arg1());
                    return;
                }
            }
            this.leafCount = (int)((long)this.leafCount + expr.leafCount());
            if (this.equationType <= 1) {
                this.equationType = 2;
            }
        }

        public IAST getValue() {
            return this.value;
        }

        public boolean isLinear() {
            return this.equationType == 0;
        }

        public boolean isLinearOrPolynomial() {
            return this.equationType == 0 || this.equationType == 1;
        }

        public void reset() {
            this.row = F.List();
            for (int i = 1; i < this.vars.size(); ++i) {
                this.row.add(F.C0);
            }
            this.value = F.Plus();
            this.equationType = 0;
        }
    }
}

