/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.convert.Expr2Object;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.RootIntervals;
import org.matheclipse.core.reflection.system.Together;

public class NRoots
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        if (ast.size() != 2) {
            return null;
        }
        IAST temp = NRoots.roots(ast);
        if (temp == null || !temp.isList()) {
            return null;
        }
        IAST list = temp;
        IAST result = F.List();
        for (int i = 1; i < list.size(); ++i) {
            result.add(F.evaln((IExpr)list.get(i)));
        }
        return result;
    }

    protected static IAST roots(IAST ast) {
        ExprVariables eVar = new ExprVariables(ast.arg1());
        if (!eVar.isSize(1)) {
            return null;
        }
        IExpr expr = F.evalExpandAll(ast.arg1());
        IAST variables = eVar.getVarList();
        ISymbol sym = (ISymbol)variables.arg1();
        double[] poly = Expr2Object.toPolynomial(expr, sym);
        IAST result = null;
        if (poly != null) {
            if (poly[3] == 0.0) {
                return NRoots.quadratic(poly[2], poly[1], poly[0]);
            }
            result = NRoots.cubic(poly[3], poly[2], poly[1], poly[0]);
            if (result != null) {
                return result;
            }
        }
        IExpr denom = F.C1;
        if (expr.isAST() && !(denom = F.eval(F.Denominator(expr = Together.together((IAST)expr)))).isOne()) {
            expr = F.eval(F.Numerator(expr));
        }
        return NRoots.rootsOfVariable(expr, denom);
    }

    protected static IAST rootsOfVariable(IExpr expr, IExpr denom) {
        IAST result = F.List();
        IAST resultList = RootIntervals.croots(expr, true);
        if (resultList != null) {
            if (resultList.size() > 0) {
                result.addAll(resultList);
            }
            return result;
        }
        return null;
    }

    private static IAST quadratic(double a, double b, double c) {
        IAST result = F.List();
        double discriminant = b * b - 4.0 * a * c;
        if (F.isZero(discriminant)) {
            double bothEqual = -b / (2.0 * a);
            result.add(F.num(bothEqual));
            result.add(F.num(bothEqual));
        } else if (discriminant < 0.0) {
            double imaginaryPart = Math.sqrt(-discriminant) / (2.0 * a);
            double realPart = -b / (2.0 * a);
            result.add(F.complex(realPart, imaginaryPart));
            result.add(F.complex(realPart, -imaginaryPart));
        } else {
            double real1 = (-b + Math.sqrt(discriminant)) / (2.0 * a);
            double real2 = (-b - Math.sqrt(discriminant)) / (2.0 * a);
            result.add(F.num(real1));
            result.add(F.num(real2));
        }
        return result;
    }

    private static IAST cubic(double a, double b, double c, double d) {
        if (F.isZero(a)) {
            return null;
        }
        if (F.isZero(d)) {
            return null;
        }
        IAST result = F.List();
        double q = (3.0 * (c /= a) - (b /= a) * b) / 9.0;
        double r = -(27.0 * (d /= a)) + b * (9.0 * c - 2.0 * (b * b));
        double discriminant = q * q * q + (r /= 54.0) * r;
        double term1 = b / 3.0;
        if (discriminant > 0.0) {
            double s = r + Math.sqrt(discriminant);
            s = s < 0.0 ? -Math.pow(-s, 0.3333333333333333) : Math.pow(s, 0.3333333333333333);
            double t = r - Math.sqrt(discriminant);
            t = t < 0.0 ? -Math.pow(-t, 0.3333333333333333) : Math.pow(t, 0.3333333333333333);
            result.add(F.num(-term1 + s + t));
            double realPart = -(term1 += (s + t) / 2.0);
            term1 = Math.sqrt(3.0) * (-t + s) / 2.0;
            result.add(F.complex(realPart, term1));
            result.add(F.complex(realPart, -term1));
            return result;
        }
        if (F.isZero(discriminant)) {
            double r13 = r < 0.0 ? -Math.pow(-r, 0.3333333333333333) : Math.pow(r, 0.3333333333333333);
            result.add(F.num(-term1 + 2.0 * r13));
            result.add(F.num(-(r13 + term1)));
            result.add(F.num(-(r13 + term1)));
            return result;
        }
        q = -q;
        double dum1 = q * q * q;
        dum1 = Math.acos(r / Math.sqrt(dum1));
        double r13 = 2.0 * Math.sqrt(q);
        result.add(F.num(-term1 + r13 * Math.cos(dum1 / 3.0)));
        result.add(F.num(-term1 + r13 * Math.cos((dum1 + Math.PI * 2) / 3.0)));
        result.add(F.num(-term1 + r13 * Math.cos((dum1 + Math.PI * 4) / 3.0)));
        return result;
    }
}

