/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Factorial;

public class Multinomial
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        for (int i = 1; i < ast.size(); ++i) {
            if (!((IExpr)ast.get(i)).isInteger()) {
                return null;
            }
            if (!((IInteger)ast.get(i)).isNegative()) continue;
            return null;
        }
        return F.integer(Multinomial.multinomial(ast));
    }

    public static BigInteger multinomial(List<IExpr> ast) {
        BigInteger[] k = new BigInteger[ast.size() - 1];
        BigInteger n = BigInteger.ZERO;
        for (int i = 1; i < ast.size(); ++i) {
            k[i - 1] = ((IInteger)ast.get(i)).getBigNumerator();
            n = n.add(k[i - 1]);
        }
        BigInteger result = Factorial.factorial(n);
        for (int i = 0; i < k.length; ++i) {
            result = result.divide(Factorial.factorial(k[i]));
        }
        return result;
    }

    public static BigInteger multinomial(int[] indices, int n) {
        BigInteger bn = BigInteger.valueOf(n);
        BigInteger result = Factorial.factorial(bn);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] == 0) continue;
            result = result.divide(Factorial.factorial(BigInteger.valueOf(indices[i])));
        }
        return result;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

