/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import java.util.Comparator;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.ExponentArray;
import org.matheclipse.core.polynomials.Polynomial;

public class MonomialList
extends AbstractFunctionEvaluator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IExpr evaluate(IAST ast) {
        ExprVariables eVar;
        Validate.checkRange(ast, 2, 5);
        IExpr expr = F.evalExpandAll(ast.arg1());
        IAST vars = F.List();
        if (ast.size() == 2) {
            eVar = new ExprVariables(ast.arg1());
            eVar.appendToList(vars);
        } else {
            IAST symbolList = Validate.checkSymbolOrSymbolList(ast, 2);
            eVar = new ExprVariables(symbolList);
            eVar.appendToList(vars);
        }
        int termOrder = 2;
        Comparator<ExponentArray> comparator = ExponentArray.lexicographic();
        try {
            Polynomial poly;
            if (ast.size() > 3) {
                if (ast.arg3() instanceof IStringX) {
                    String orderStr = ast.arg3().toString();
                    if (!orderStr.equals("DegreeLexicographic")) return null;
                    termOrder = 1;
                    comparator = ExponentArray.degreeLexicographic();
                } else {
                    Options options = new Options(ast.topHead(), ast, 2);
                    IExpr option = options.getOption("Modulus");
                    if (option == null || !option.isSignedNumber()) return null;
                    return MonomialList.monomialListModulus(expr, eVar.getArrayList(), termOrder, option);
                }
            }
            if (!(poly = new Polynomial(expr, vars, comparator)).isPolynomial()) throw new WrongArgumentType(ast, expr, 1, "Polynomial expected!");
            return poly.monomialList();
        }
        catch (JASConversionException jce) {
            return null;
        }
    }

    private static IAST monomialListModulus(IExpr polynomial, List<IExpr> variablesList, int termOrder, IExpr option) throws JASConversionException {
        try {
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(variablesList, modIntegerRing);
            GenPolynomial<ModLong> polyExpr = jas.expr2JAS(polynomial);
            IAST list = F.List();
            for (Monomial<ModLong> monomial : polyExpr) {
                ModLong coeff = monomial.coefficient();
                ExpVector exp = monomial.exponent();
                IAST monomTimes = F.Times((IExpr)F.integer(coeff.getVal()));
                for (int i = 0; i < exp.length(); ++i) {
                    long lExp = exp.getVal(i);
                    if (lExp == 0L) continue;
                    ISymbol variable = (ISymbol)variablesList.get(i);
                    monomTimes.add(F.Power((IExpr)variable, F.integer(lExp)));
                }
                list.add(monomTimes);
            }
            return list;
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }
}

