/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ITernaryComparator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.list.algorithms.EvaluationSupport;
import org.matheclipse.core.reflection.system.Greater;

public class Min
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2);
        IAST list = ast;
        IAST resultList = list.copyHead();
        if (EvaluationSupport.flatten(F.List, list, resultList)) {
            list = resultList;
        }
        IExpr min1 = list.arg1();
        IAST f = list.copyHead();
        for (int i = 2; i < list.size(); ++i) {
            IExpr min2 = (IExpr)list.get(i);
            if (min1.equals(min2)) continue;
            ITernaryComparator.COMPARE_RESULT comp = Greater.CONST.prepareCompare(min1, min2);
            if (comp == ITernaryComparator.COMPARE_RESULT.TRUE) {
                min1 = min2;
                continue;
            }
            if (comp != ITernaryComparator.COMPARE_RESULT.UNDEFINED) continue;
            if (min1.isNumber()) {
                f.add(min2);
                continue;
            }
            f.add(min1);
            min1 = min2;
        }
        if (f.size() > 1) {
            f.add(1, min1);
            if (f.equals(list)) {
                return null;
            }
            return f;
        }
        return min1;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1036);
        super.setUp(symbol);
    }
}

