/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Thread;
import org.matheclipse.core.visit.VisitorLevelSpecification;

public class MapThread
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        VisitorLevelSpecification level = null;
        UnaryMapThread umt = new UnaryMapThread(ast.arg1());
        level = ast.size() == 4 ? new VisitorLevelSpecification((Function<IExpr, IExpr>)umt, ast.arg3(), false) : new VisitorLevelSpecification(umt, 0);
        IExpr result = ast.arg2().accept(level);
        return result == null ? ast.arg2() : result;
    }

    private static class UnaryMapThread
    implements Function<IExpr, IExpr> {
        final IExpr fConstant;

        public UnaryMapThread(IExpr constant) {
            this.fConstant = constant;
        }

        @Override
        public IExpr apply(IExpr firstArg) {
            if (firstArg.isAST()) {
                IAST result = Thread.threadList((IAST)firstArg, F.List, this.fConstant, 1);
                if (result == null) {
                    return firstArg;
                }
                return result;
            }
            return firstArg;
        }
    }
}

