/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexUtils;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.generic.BinaryFunctorImpl;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.rules.LogRules;
import org.matheclipse.parser.client.SyntaxError;

public class Log
extends AbstractArg12
implements INumeric,
LogRules {
    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e1DblArg(INum arg1) {
        return Num.valueOf(Math.log(arg1.getRealPart()));
    }

    @Override
    public IExpr e1DblComArg(IComplexNum arg1) {
        return ComplexUtils.log((ComplexNum)arg1);
    }

    @Override
    public IExpr e2DblArg(INum arg1, INum arg2) {
        return Num.valueOf(Math.log(arg2.getRealPart()) / Math.log(arg1.getRealPart()));
    }

    @Override
    public IExpr e2IntArg(IInteger arg1, IInteger arg2) {
        return Log.baseBLog(arg1, arg2);
    }

    public static IExpr baseBLog(IInteger b, IInteger arg) {
        try {
            int r;
            long l1 = b.toLong();
            long l2 = arg.toLong();
            double res = Math.log(l2) / Math.log(l1);
            if (F.isNumIntValue(res) && arg.equals(b.pow(r = Double.valueOf(Math.round(res)).intValue()))) {
                return F.integer(r);
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    public static BinaryFunctorImpl<IExpr> getFunction() {
        return new BinaryFunctorImpl<IExpr>(){

            @Override
            public IExpr apply(IExpr arg1, IExpr arg2) {
                if (arg1.isInteger() && arg2.isInteger()) {
                    return Log.baseBLog((IInteger)arg2, (IInteger)arg1);
                }
                return null;
            }
        };
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.log(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }

    @Override
    public IExpr e1ObjArg(IExpr arg1) {
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null && negExpr.isPositive()) {
            return F.Plus((IExpr)F.Log(negExpr), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Pi));
        }
        return null;
    }
}

