/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.ArrayList;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.PivotSelectionRule;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.matheclipse.core.convert.Expr2Object;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrappedException;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;

public class LinearProgramming
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        return this.numericEval(ast);
    }

    @Override
    public IExpr numericEval(IAST ast) {
        Validate.checkSize(ast, 4);
        try {
            if (ast.arg1().isList() && ast.arg2().isList() && ast.arg3().isList()) {
                double[] arg1D = Expr2Object.toDoubleVector((IAST)ast.arg1());
                LinearObjectiveFunction f = new LinearObjectiveFunction(arg1D, 0.0);
                ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
                IAST arg2 = (IAST)ast.arg2();
                IAST arg3 = (IAST)ast.arg3();
                if (arg2.size() != arg3.size()) {
                    return null;
                }
                for (int i = 1; i < arg2.size(); ++i) {
                    double[] arg2D = Expr2Object.toDoubleVector((IAST)arg2.get(i));
                    if (((IExpr)arg2.get(i)).isList()) {
                        if (((IExpr)arg3.get(i)).isList()) {
                            double[] arg3D = Expr2Object.toDoubleVector((IAST)arg3.get(i));
                            if (arg3D.length >= 2) {
                                double val = arg3D[1];
                                if (val == 0.0) {
                                    constraints.add(new LinearConstraint(arg2D, Relationship.EQ, arg3D[0]));
                                    continue;
                                }
                                if (val < 0.0) {
                                    constraints.add(new LinearConstraint(arg2D, Relationship.LEQ, arg3D[0]));
                                    continue;
                                }
                                if (!(val > 0.0)) continue;
                                constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                                continue;
                            }
                            if (arg3D.length != 1) continue;
                            constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, arg3D[0]));
                            continue;
                        }
                        if (((IExpr)arg3.get(i)).isSignedNumber()) {
                            constraints.add(new LinearConstraint(arg2D, Relationship.GEQ, ((ISignedNumber)arg3.get(i)).doubleValue()));
                            continue;
                        }
                        throw new WrongArgumentType(arg3, (IExpr)arg3.get(i), i, "Numeric vector or number expected!");
                    }
                    throw new WrongArgumentType(ast, (IExpr)ast.get(i), i, "Numeric vector expected!");
                }
                SimplexSolver solver = new SimplexSolver();
                PointValuePair solution = solver.optimize(f, new LinearConstraintSet(constraints), GoalType.MINIMIZE, new NonNegativeConstraint(true), PivotSelectionRule.BLAND);
                double[] values = solution.getPointRef();
                return F.List(values);
            }
        }
        catch (MathIllegalStateException oe) {
            throw new WrappedException(oe);
        }
        return null;
    }
}

