/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.poly.GenPolynomial;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.RecursionLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.PartialFractionGenerator;
import org.matheclipse.core.reflection.system.Apart;
import org.matheclipse.core.reflection.system.PolynomialQ;
import org.matheclipse.core.reflection.system.rules.LimitRules;

public class Limit
extends AbstractFunctionEvaluator
implements LimitRules {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpr lHospitalesRule(IExpr numerator, IExpr denominator, ISymbol x, IExpr limit, IAST rule, int direction) {
        EvalEngine engine = EvalEngine.get();
        int recursionLimit = engine.getRecursionLimit();
        if (recursionLimit > 0) {
            IExpr expr = F.evalQuiet(F.Times((IExpr)F.D(numerator, x), (IExpr)F.Power((IExpr)F.D(denominator, x), F.CN1)));
            return Limit.evalLimit(expr, x, limit, rule, direction, false);
        }
        try {
            if (recursionLimit <= 0) {
                engine.setRecursionLimit(128);
            }
            IExpr expr = F.evalQuiet(F.Times((IExpr)F.D(numerator, x), (IExpr)F.Power((IExpr)F.D(denominator, x), F.CN1)));
            IExpr iExpr = Limit.evalLimit(expr, x, limit, rule, direction, false);
            return iExpr;
        }
        catch (RecursionLimitExceeded rle) {
            engine.setRecursionLimit(recursionLimit);
        }
        finally {
            engine.setRecursionLimit(recursionLimit);
        }
        return null;
    }

    public static IExpr evalLimit(IExpr expr, ISymbol symbol, IExpr limit, IAST rule, int direction, boolean evalExpr) {
        IExpr expression = expr;
        if (evalExpr) {
            IExpr result = F.evalQuiet(expression);
            if (result.isNumericFunction()) {
                return result;
            }
            if (!result.equals(F.Indeterminate)) {
                expression = result;
            }
            if (limit.isNumericFunction() && (result = expression.replaceAll(rule)) != null && (result = F.evalQuiet(result)).isNumericFunction()) {
                return result;
            }
        }
        if (expression.isFree(symbol, true)) {
            return expression;
        }
        if (expression.equals(symbol)) {
            return limit;
        }
        if (expression.isAST()) {
            IAST arg1 = (IAST)expression;
            if (arg1.isSin() || arg1.isCos()) {
                return F.$(arg1.head(), F.Limit(arg1.arg1(), rule));
            }
            if (arg1.isPlus()) {
                return Limit.plusLimit(arg1, symbol, limit, rule);
            }
            if (arg1.isTimes()) {
                return Limit.timesLimit(arg1, symbol, limit, direction, rule);
            }
            if (arg1.isPower() && arg1.arg2().isNumericFunction()) {
                IExpr exp = arg1.arg2();
                IExpr temp = F.evalQuiet(F.Limit(arg1.arg1(), rule));
                if (temp.isNumericFunction()) {
                    if (temp.isZero() && exp.isNegative()) {
                        return null;
                    }
                    return F.Power(temp, exp);
                }
                if (exp.isInteger()) {
                    IInteger n = (IInteger)exp;
                    if (temp.isInfinity()) {
                        if (n.isPositive()) {
                            return temp;
                        }
                        if (n.isNegative()) {
                            return F.C0;
                        }
                        return null;
                    }
                    if (temp.isNegativeInfinity()) {
                        if (n.isPositive()) {
                            if (n.isEven()) {
                                return F.CInfinity;
                            }
                            return F.CNInfinity;
                        }
                        if (n.isNegative()) {
                            return F.C0;
                        }
                        return null;
                    }
                    if (temp.equals(F.Indeterminate) || temp.isAST(F.Limit)) {
                        return null;
                    }
                    if (n.isPositive()) {
                        return F.Power(temp, n);
                    }
                    if (n.isNegative() && n.isEven()) {
                        return F.Power(temp, n);
                    }
                }
            }
        }
        return null;
    }

    public static IExpr plusLimit(IAST arg1, ISymbol symbol, IExpr limit, IAST rule) {
        GenPolynomial<IExpr> poly;
        if ((limit.isInfinity() || limit.isNegativeInfinity()) && (poly = PolynomialQ.polynomial((IExpr)arg1, symbol, true)) != null) {
            IExpr coeff = poly.leadingBaseCoefficient();
            long oddDegree = poly.degree() % 2L;
            if (oddDegree == 1L) {
                return F.Limit(F.Times(coeff, limit), rule);
            }
            return F.Limit(F.Times(coeff, (IExpr)F.CInfinity), rule);
        }
        return Limit.mapLimit(arg1, rule);
    }

    public static IExpr timesLimit(IAST arg1, ISymbol symbol, IExpr limit, int direction, IAST rule) {
        IExpr[] parts = Apart.getFractionalPartsTimes(arg1, false);
        if (parts != null) {
            IExpr temp;
            GenPolynomial<IExpr> numeratorPoly;
            GenPolynomial<IExpr> denominatorPoly;
            IExpr numerator = parts[0];
            IExpr denominator = parts[1];
            if ((limit.isInfinity() || limit.isNegativeInfinity()) && (denominatorPoly = PolynomialQ.polynomial(denominator, symbol, true)) != null && (numeratorPoly = PolynomialQ.polynomial(numerator, symbol, true)) != null) {
                return Limit.limitsInfinityOfRationalFunctions(numeratorPoly, denominatorPoly, symbol, limit, rule);
            }
            IAST plusResult = Apart.partialFractionDecompositionRational(new PartialFractionGenerator(), parts, symbol);
            if (plusResult != null && plusResult.size() > 2) {
                return Limit.mapLimit(plusResult, rule);
            }
            if (denominator.isOne() && (limit.isInfinity() || limit.isNegativeInfinity()) && (temp = Limit.substituteInfinity(arg1, symbol, limit, direction)) != null) {
                return temp;
            }
            temp = Limit.numeratorDenominatorLimit(numerator, denominator, symbol, limit, rule, direction);
            if (temp != null) {
                return temp;
            }
        }
        return Limit.mapLimit(arg1, rule);
    }

    private static IExpr substituteInfinity(IAST arg1, ISymbol x, IExpr limit, int direction) {
        IExpr[] parts;
        IAST y = F.Power((IExpr)x, F.CN1);
        IExpr temp = F.evalQuiet(F.subst(arg1, x, y));
        if (temp.isTimes() && (parts = Apart.getFractionalPartsTimes((IAST)temp, false)) != null && !parts[1].isOne() && (temp = Limit.numeratorDenominatorLimit(parts[0], parts[1], x, F.C0, F.Rule(x, F.C0), direction)) != null) {
            return temp;
        }
        return null;
    }

    private static IExpr limitsInfinityOfRationalFunctions(GenPolynomial<IExpr> numeratorPoly, GenPolynomial<IExpr> denominatorPoly, ISymbol symbol, IExpr limit, IAST rule) {
        long denomDegree;
        long numDegree = numeratorPoly.degree();
        if (numDegree > (denomDegree = denominatorPoly.degree())) {
            long oddDegree = (numDegree + denomDegree) % 2L;
            if (oddDegree == 1L) {
                return F.Limit(F.Times((IExpr)F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient()), limit), rule);
            }
            return F.Limit(F.Times((IExpr)F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient()), (IExpr)F.CInfinity), rule);
        }
        if (numDegree < denomDegree) {
            return F.C0;
        }
        return F.Divide(numeratorPoly.leadingBaseCoefficient(), denominatorPoly.leadingBaseCoefficient());
    }

    private static IExpr mapLimit(IAST expr, IAST rule) {
        return expr.mapAt(F.Limit(null, rule), 1);
    }

    private static IExpr numeratorDenominatorLimit(IExpr numerator, IExpr denominator, ISymbol x, IExpr limit, IAST rule, int direction) {
        if (denominator.isOne() && numerator.isTimes()) {
            return Limit.mapLimit((IAST)numerator, rule);
        }
        if (!denominator.isNumber() || denominator.isZero()) {
            IExpr denValue = F.evalBlock(denominator, x, limit);
            if (denValue.equals(F.Indeterminate)) {
                return null;
            }
            if (denValue.isZero()) {
                IExpr numValue = F.evalBlock(numerator, x, limit);
                if (numValue.isZero()) {
                    return Limit.lHospitalesRule(numerator, denominator, x, limit, rule, direction);
                }
                return null;
            }
            if (F.CInfinity.equals(denValue)) {
                IExpr numValue = F.evalBlock(numerator, x, limit);
                if (F.CInfinity.equals(numValue)) {
                    return Limit.lHospitalesRule(numerator, denominator, x, limit, rule, direction);
                }
                return null;
            }
            if (denValue.isNegativeInfinity()) {
                IExpr numValue = F.evalBlock(numerator, x, limit);
                if (numValue.isNegativeInfinity()) {
                    return Limit.lHospitalesRule(numerator, denominator, x, limit, rule, direction);
                }
                return null;
            }
        }
        return F.Times((IExpr)F.Limit(numerator, rule), (IExpr)F.Power((IExpr)F.Limit(denominator, rule), F.CN1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        if (!ast.arg2().isRuleAST()) {
            throw new WrongArgumentType(ast, ast.arg2(), 2, "Limit: rule definition expected!");
        }
        IAST rule = (IAST)ast.arg2();
        if (!rule.arg1().isSymbol()) {
            throw new WrongArgumentType(ast, ast.arg1(), 2, "Limit: variable symbol for rule definition expected!");
        }
        int direction = 0;
        if (ast.size() == 4) {
            Options options = new Options(ast.topHead(), ast, 2);
            IExpr option = options.getOption("Direction");
            if (option == null) throw new WrongArgumentType(ast, ast.arg2(), 2, "Limit: direction option expected!");
            if (option.isOne()) {
                direction = 1;
            } else {
                if (!option.isMinusOne()) throw new WrongArgumentType(ast, ast.arg2(), 2, "Limit: direction option expected!");
                direction = -1;
            }
        }
        ISymbol symbol = (ISymbol)rule.arg1();
        IExpr limit = null;
        if (!rule.isFreeAt(2, symbol)) {
            throw new WrongArgumentType(ast, (IExpr)ast.get(2), 2, "Limit: limit value contains variable symbol for rule definition!");
        }
        limit = rule.arg2();
        return Limit.evalLimit(ast.arg1(), symbol, limit, rule, direction, true);
    }

    @Override
    public IAST getRuleAST() {
        return RULES;
    }
}

