/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.matheclipse.core.convert.Convert;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ExprFieldElement;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class LUDecomposition
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        try {
            IAST list = (IAST)ast.arg1();
            FieldMatrix<ExprFieldElement> matrix = Convert.list2Matrix(list);
            FieldLUDecomposition<ExprFieldElement> lu = new FieldLUDecomposition<ExprFieldElement>(matrix);
            FieldMatrix<ExprFieldElement> lMatrix = lu.getL();
            FieldMatrix<ExprFieldElement> uMatrix = lu.getU();
            int[] iArr = lu.getPivot();
            IAST iList = F.List();
            for (int i = 0; i < iArr.length; ++i) {
                iList.add(F.integer(iArr[i] + 1));
            }
            IAST result = F.List();
            IAST lMatrixAST = Convert.matrix2List(lMatrix);
            IAST uMatrixAST = Convert.matrix2List(uMatrix);
            result.add(lMatrixAST);
            result.add(uMatrixAST);
            result.add(iList);
            return result;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }
}

