/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class InterpolatingPolynomial
implements IFunctionEvaluator {
    protected static IExpr[] computeDividedDifference(IExpr[] x, IExpr[] y) {
        IExpr[] divdiff = (IExpr[])y.clone();
        int n = x.length;
        IExpr[] a = new IExpr[n];
        a[0] = divdiff[0];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                IExpr denominator = F.eval(F.Subtract(x[j + i], x[j]));
                divdiff[j] = F.eval(F.Divide(F.Subtract(divdiff[j + 1], divdiff[j]), denominator));
            }
            a[i] = divdiff[0];
        }
        return a;
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1().isList() && ast.arg2().isSymbol()) {
            IAST list = (IAST)ast.arg1();
            ISymbol x = (ISymbol)ast.arg2();
            if (list.size() > 1) {
                IAST polynomial;
                int i;
                int n = list.size() - 1;
                IExpr[] xv = new IExpr[n];
                IExpr[] yv = new IExpr[n];
                int[] dim = list.isMatrix();
                if (dim != null && dim[1] == 2) {
                    if (dim[1] != 2) {
                        return null;
                    }
                    for (i = 0; i < n; ++i) {
                        IAST row = list.getAST(i + 1);
                        xv[i] = row.arg1();
                        yv[i] = row.arg2();
                    }
                } else {
                    for (i = 0; i < n; ++i) {
                        xv[i] = F.integer(i + 1);
                        yv[i] = (IExpr)list.get(i + 1);
                    }
                }
                IExpr[] c = InterpolatingPolynomial.computeDividedDifference(xv, yv);
                IAST tempPlus = polynomial = F.Plus();
                polynomial.add(c[0]);
                for (int i2 = 2; i2 < list.size(); ++i2) {
                    IAST times = F.Times();
                    IAST plus = F.Plus();
                    times.add(plus);
                    times.add(F.Subtract(x, xv[i2 - 2]));
                    tempPlus.add(times);
                    tempPlus = plus;
                    tempPlus.add(c[i2 - 1]);
                }
                return polynomial;
            }
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

