/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class IntegerPart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        try {
            IExpr arg1 = ast.arg1();
            ISignedNumber signedNumber = NumericQ.getSignedNumberNumericQ(arg1);
            if (signedNumber != null) {
                return this.signedNumberIntegerPart(signedNumber);
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr != null) {
                return F.Times((IExpr)F.CN1, (IExpr)F.IntegerPart(negExpr));
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    private IExpr signedNumberIntegerPart(ISignedNumber arg1) {
        ISignedNumber signedNumber = arg1;
        if (signedNumber.isNegative()) {
            return signedNumber.ceil();
        }
        return signedNumber.floor();
    }

    @Override
    public IExpr numericEval(IAST ast) {
        return this.evaluate(ast);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(25728);
        super.setUp(symbol);
    }
}

