/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.polynomials.HornerScheme;

public class HornerForm
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        if (arg1.isAST()) {
            IAST variables;
            IAST poly = (IAST)arg1;
            if (ast.size() == 3) {
                variables = Validate.checkSymbolOrSymbolList(ast, 2);
            } else {
                ExprVariables eVar = new ExprVariables(ast.arg1());
                variables = eVar.getVarList();
            }
            if (variables.size() >= 2) {
                ISymbol sym = (ISymbol)variables.arg1();
                if (poly.isASTSizeGE(F.Plus, 2)) {
                    HornerScheme scheme = new HornerScheme();
                    return scheme.generate(EvalEngine.get().isNumericMode(), poly, sym);
                }
            }
        }
        return arg1;
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

