/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.gbufd.GroebnerBasePartial;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.OptimizedPolynomialList;
import java.util.ArrayList;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class GroebnerBasis
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST lst) {
        if (lst.size() >= 3) {
            try {
                if (lst.arg1().isVector() < 0) {
                    return null;
                }
                if (((IExpr)lst.get(2)).isVector() < 0) {
                    return null;
                }
                if (lst.size() == 3) {
                    IAST vars = (IAST)lst.get(2);
                    if (vars.size() <= 1) {
                        return null;
                    }
                    ArrayList<ISymbol> varList = new ArrayList<ISymbol>(vars.size() - 1);
                    String[] pvars = new String[vars.size() - 1];
                    for (int i = 1; i < vars.size(); ++i) {
                        if (!((IExpr)vars.get(i)).isSymbol()) {
                            return null;
                        }
                        varList.add((ISymbol)vars.get(i));
                        pvars[i - 1] = ((ISymbol)vars.get(i)).toString();
                    }
                    GroebnerBasePartial gbp = new GroebnerBasePartial();
                    IAST polys = (IAST)lst.arg1();
                    ArrayList polyList = new ArrayList(polys.size() - 1);
                    JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, BigRational.ZERO);
                    for (int i = 1; i < polys.size(); ++i) {
                        IExpr expr = F.evalExpandAll((IExpr)polys.get(i));
                        GenPolynomial<BigRational> poly = jas.expr2JAS(expr, false);
                        polyList.add(poly);
                    }
                    OptimizedPolynomialList opl = gbp.partialGB(polyList, pvars);
                    IAST resultList = F.List();
                    for (GenPolynomial p : opl.list) {
                        resultList.add(jas.poly2Expr(p, null));
                    }
                    return resultList;
                }
            }
            catch (JASConversionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

