/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.ITernaryComparator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Greater
extends AbstractFunctionEvaluator
implements ITernaryComparator<IExpr> {
    public static final Greater CONST = new Greater();

    protected IExpr simplifyCompare(IExpr a1, IExpr a2) {
        return this.simplifyCompare(a1, a2, F.Greater, F.Less);
    }

    protected final IExpr simplifyCompare(IExpr a1, IExpr a2, ISymbol originalHead, ISymbol oppositeHead) {
        ISignedNumber rhs;
        IExpr lhs;
        boolean useOppositeHeader = false;
        if (a2.isSignedNumber()) {
            lhs = a1;
            rhs = (ISignedNumber)a2;
        } else if (a1.isSignedNumber()) {
            lhs = a2;
            rhs = (ISignedNumber)a1;
            useOppositeHeader = true;
        } else {
            lhs = F.eval(F.Subtract(a1, a2));
            rhs = F.C0;
        }
        if (lhs.isAST()) {
            IAST lhsAST = (IAST)lhs;
            if (lhsAST.isTimes()) {
                if (lhsAST.arg1().isSignedNumber()) {
                    ISignedNumber sn = (ISignedNumber)lhsAST.arg1();
                    if (sn.isNegative()) {
                        useOppositeHeader = !useOppositeHeader;
                    }
                    rhs = rhs.divideBy(sn);
                    return this.createComparatorResult(lhsAST, rhs, useOppositeHeader, originalHead, oppositeHead);
                }
            } else if (lhsAST.isPlus() && lhsAST.arg1().isSignedNumber()) {
                ISignedNumber sn = (ISignedNumber)lhsAST.arg1();
                rhs = rhs.subtractFrom(sn);
                return this.createComparatorResult(lhsAST, rhs, useOppositeHeader, originalHead, oppositeHead);
            }
        }
        return null;
    }

    private IExpr createComparatorResult(IAST lhsAST, IExpr rhs, boolean useOppositeHeader, ISymbol originalHead, ISymbol oppositeHead) {
        IAST lhsClone = lhsAST.removeAtClone(1);
        if (useOppositeHeader) {
            return F.binary(oppositeHead, lhsClone, rhs);
        }
        return F.binary(originalHead, lhsClone, rhs);
    }

    @Override
    public IExpr evaluate(IAST ast) {
        int i;
        IExpr result;
        Validate.checkRange(ast, 3);
        if (ast.size() == 3 && (result = this.simplifyCompare(ast.arg1(), ast.arg2())) != null) {
            return result;
        }
        ITernaryComparator.COMPARE_RESULT b = ITernaryComparator.COMPARE_RESULT.UNDEFINED;
        boolean evaled = false;
        IAST result2 = ast.clone();
        ITernaryComparator.COMPARE_RESULT[] cResult = new ITernaryComparator.COMPARE_RESULT[ast.size()];
        cResult[0] = ITernaryComparator.COMPARE_RESULT.TRUE;
        for (i = 1; i < ast.size() - 1; ++i) {
            b = this.prepareCompare((IExpr)result2.get(i), (IExpr)result2.get(i + 1));
            if (b == ITernaryComparator.COMPARE_RESULT.FALSE) {
                return F.False;
            }
            if (b == ITernaryComparator.COMPARE_RESULT.TRUE) {
                evaled = true;
            }
            cResult[i] = b;
        }
        cResult[ast.size() - 1] = ITernaryComparator.COMPARE_RESULT.TRUE;
        if (!evaled) {
            return null;
        }
        i = 2;
        evaled = false;
        for (int j = 1; j < ast.size(); ++j) {
            if (cResult[j - 1] == ITernaryComparator.COMPARE_RESULT.TRUE && cResult[j] == ITernaryComparator.COMPARE_RESULT.TRUE) {
                evaled = true;
                result2.remove(i - 1);
                continue;
            }
            ++i;
        }
        if (evaled) {
            if (result2.size() <= 2) {
                return F.True;
            }
            return result2;
        }
        return null;
    }

    public ITernaryComparator.COMPARE_RESULT prepareCompare(IExpr o0, IExpr o1) {
        IExpr a0 = o0;
        IExpr a1 = o1;
        if (!a0.isSignedNumber() && NumericQ.CONST.apply(a0)) {
            a0 = F.evaln(a0);
        }
        if (!a1.isSignedNumber() && NumericQ.CONST.apply(a1)) {
            a1 = F.evaln(a1);
        }
        if (a0.isNumeric() && a1.isRational()) {
            a1 = F.evaln(a1);
        }
        if (a1.isNumeric() && a0.isRational()) {
            a0 = F.evaln(a0);
        }
        return this.compare(a0, a1);
    }

    @Override
    public ITernaryComparator.COMPARE_RESULT compare(IExpr a0, IExpr a1) {
        if (a0.isSignedNumber()) {
            if (a1.isSignedNumber()) {
                return a1.isLTOrdered(a0) ? ITernaryComparator.COMPARE_RESULT.TRUE : ITernaryComparator.COMPARE_RESULT.FALSE;
            }
            if (a1.isInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.FALSE;
            }
            if (a1.isNegativeInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.TRUE;
            }
        } else if (a1.isSignedNumber()) {
            if (a0.isInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.TRUE;
            }
            if (a0.isNegativeInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.FALSE;
            }
        } else {
            if (a0.isInfinity() && a1.isNegativeInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.TRUE;
            }
            if (a0.isNegativeInfinity() && a1.isInfinity()) {
                return ITernaryComparator.COMPARE_RESULT.FALSE;
            }
        }
        if (a0.equals(a1)) {
            return ITernaryComparator.COMPARE_RESULT.FALSE;
        }
        return ITernaryComparator.COMPARE_RESULT.UNDEFINED;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(8);
    }
}

