/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class FractionalPart
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        ISignedNumber signedNumber = NumericQ.getSignedNumberNumericQ(arg1);
        if (signedNumber != null) {
            return this.signedNumberFractionalPart(signedNumber);
        }
        IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
        if (negExpr != null) {
            return F.Times((IExpr)F.CN1, (IExpr)F.FractionalPart(negExpr));
        }
        return null;
    }

    private IExpr signedNumberFractionalPart(INumber arg1) {
        if (arg1.isInteger()) {
            return F.C0;
        }
        if (arg1.isFraction()) {
            BigInteger den;
            IFraction fr = (IFraction)arg1;
            BigInteger num = fr.getBigNumerator();
            BigInteger div = num.divide(den = fr.getBigDenominator());
            if (div.equals(BigInteger.ZERO)) {
                return F.C0;
            }
            return F.fraction(div, den);
        }
        if (arg1 instanceof INum) {
            INum num = (INum)arg1;
            return F.num(num.getRealPart() % 1.0);
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(25728);
        super.setUp(symbol);
    }
}

