/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.base.Function;
import org.matheclipse.core.builtin.function.NumericQ;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Floor
extends AbstractFunctionEvaluator
implements INumeric {
    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.floor(stack[top]);
    }

    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        try {
            IAST[] result;
            IExpr arg1 = F.eval(ast.arg1());
            ISignedNumber signedNumber = NumericQ.getSignedNumberNumericQ(arg1);
            if (signedNumber != null) {
                return signedNumber.floor();
            }
            if (arg1.isPlus() && (result = ((IAST)arg1).filter(new FloorPlusFunction()))[0].size() > 1) {
                if (result[1].size() > 1) {
                    result[0].add(F.Floor(result[1]));
                }
                return result[0];
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr != null) {
                return F.Times((IExpr)F.CN1, (IExpr)F.Ceiling(negExpr));
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1248);
        super.setUp(symbol);
    }

    private final class FloorPlusFunction
    implements Function<IExpr, IExpr> {
        private FloorPlusFunction() {
        }

        @Override
        public IExpr apply(IExpr expr) {
            if (expr.isInteger()) {
                return expr;
            }
            return null;
        }
    }
}

