/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import java.math.BigInteger;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class FactorTerms
extends AbstractFunctionEvaluator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        IAST variableList = F.List();
        if (ast.size() == 3) {
            if (((IExpr)ast.get(2)).isSymbol()) {
                ISymbol variable = (ISymbol)ast.get(2);
                variableList = F.List((IExpr)variable);
            } else {
                if (!((IExpr)ast.get(2)).isList()) return null;
                variableList = (IAST)ast.get(2);
            }
        } else if (ast.size() == 2) {
            ExprVariables eVar = new ExprVariables(ast.arg1());
            if (!eVar.isSize(1)) {
                return null;
            }
            variableList = eVar.getVarList();
        }
        if (variableList.size() != 2) {
            return null;
        }
        ASTRange r = new ASTRange(variableList, 1);
        IExpr expr = F.evalExpandAll(ast.arg1());
        try {
            JASConvert<BigRational> jas = new JASConvert<BigRational>(r.toList(), BigRational.ZERO);
            GenPolynomial<BigRational> poly = jas.expr2JAS(expr, false);
            Object[] objects = jas.factorTerms(poly);
            BigInteger gcd = (BigInteger)objects[0];
            BigInteger lcm = (BigInteger)objects[1];
            if (lcm.equals(BigInteger.ZERO)) {
                return expr;
            }
            GenPolynomial iPoly = (GenPolynomial)objects[2];
            IAST result = F.Times();
            result.add(F.fraction(gcd, lcm));
            result.add(jas.integerPoly2Expr(iPoly));
            return result;
        }
        catch (JASConversionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(8);
    }
}

