/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class ExtendedGCD
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        for (int i = 1; i < ast.size(); ++i) {
            IExpr arg = (IExpr)ast.get(i);
            if (!arg.isInteger()) {
                return null;
            }
            if (((IInteger)arg).isPositive()) continue;
            return null;
        }
        try {
            BigInteger gcd = ((IInteger)ast.arg1()).getBigNumerator();
            BigInteger factor = BigInteger.ONE;
            BigInteger[] subBezouts = new BigInteger[ast.size() - 1];
            Object[] stepResult = ExtendedGCD.extendedGCD(((IInteger)ast.arg2()).getBigNumerator(), gcd);
            gcd = (BigInteger)stepResult[0];
            subBezouts[0] = ((BigInteger[])stepResult[1])[0];
            subBezouts[1] = ((BigInteger[])stepResult[1])[1];
            for (int i = 3; i < ast.size(); ++i) {
                stepResult = ExtendedGCD.extendedGCD(((IInteger)ast.get(i)).getBigNumerator(), gcd);
                gcd = (BigInteger)stepResult[0];
                factor = ((BigInteger[])stepResult[1])[0];
                for (int j = 0; j < i - 1; ++j) {
                    subBezouts[j] = subBezouts[j].multiply(factor);
                }
                subBezouts[i - 1] = ((BigInteger[])stepResult[1])[1];
            }
            IAST subList = F.List();
            for (int i = 0; i < subBezouts.length; ++i) {
                subList.add(F.integer(subBezouts[i]));
            }
            IAST list = F.List();
            list.add(F.integer(gcd));
            list.add(subList);
            return list;
        }
        catch (ArithmeticException ae) {
            ae.printStackTrace();
            return null;
        }
    }

    public static Object[] extendedGCD(BigInteger numberOne, BigInteger numberTwo) throws ArithmeticException {
        Object[] results = new Object[2];
        BigInteger gcd = BigInteger.ONE;
        BigInteger mValue = BigInteger.ONE;
        BigInteger nValue = BigInteger.ONE;
        BigInteger remainder = BigInteger.ONE;
        BigInteger xValue = BigInteger.ZERO;
        BigInteger lastxValue = BigInteger.ONE;
        BigInteger yValue = BigInteger.ONE;
        BigInteger lastyValue = BigInteger.ZERO;
        if (numberOne.compareTo(BigInteger.ZERO) != 0 && numberTwo.compareTo(BigInteger.ZERO) != 0 && numberOne.compareTo(BigInteger.ZERO) == 1 && numberTwo.compareTo(BigInteger.ZERO) == 1) {
            BigInteger divisor;
            BigInteger dividend;
            boolean exchange;
            if (numberOne.compareTo(numberTwo) == 1) {
                exchange = false;
                dividend = numberOne;
                divisor = numberTwo;
            } else {
                exchange = true;
                dividend = numberTwo;
                divisor = numberOne;
            }
            BigInteger[] divisionResult = null;
            while (remainder.compareTo(BigInteger.ZERO) != 0) {
                divisionResult = dividend.divideAndRemainder(divisor);
                BigInteger quotient = divisionResult[0];
                remainder = divisionResult[1];
                dividend = divisor;
                divisor = remainder;
                BigInteger tempValue = xValue;
                xValue = lastxValue.subtract(quotient.multiply(xValue));
                lastxValue = tempValue;
                tempValue = yValue;
                yValue = lastyValue.subtract(quotient.multiply(yValue));
                lastyValue = tempValue;
            }
            gcd = dividend;
            if (exchange) {
                mValue = lastyValue;
                nValue = lastxValue;
            } else {
                mValue = lastxValue;
                nValue = lastyValue;
            }
        } else {
            throw new ArithmeticException("ExtendedGCD contains wrong arguments");
        }
        results[0] = gcd;
        BigInteger[] values = new BigInteger[]{nValue, mValue};
        results[1] = values;
        return results;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

