/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.Set;
import java.util.TreeSet;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.patternmatching.PatternMatcher;

public class Exponent
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3, 4);
        IExpr form = ast.arg2();
        if (form.isList()) {
            return ((IAST)form).mapAt(ast, 2);
        }
        ISymbol sym = F.Max;
        if (ast.size() == 4) {
            sym = Validate.checkSymbolType(ast, 3);
        }
        TreeSet<IExpr> collector = new TreeSet<IExpr>();
        IExpr expr = F.evalExpandAll(ast.arg1());
        if (expr.equals(F.C0)) {
            collector.add(F.CNInfinity);
        } else if (expr.isAST()) {
            IAST arg1 = (IAST)expr;
            PatternMatcher matcher = new PatternMatcher(form);
            if (arg1.isPower()) {
                if (((IPatternMatcher)matcher).apply(arg1.arg1())) {
                    collector.add(arg1.arg2());
                } else {
                    collector.add(F.C0);
                }
            } else if (arg1.isPlus()) {
                for (int i = 1; i < arg1.size(); ++i) {
                    if (((IExpr)arg1.get(i)).isAtom()) {
                        if (((IExpr)arg1.get(i)).isSymbol()) {
                            if (((IPatternMatcher)matcher).apply((IExpr)arg1.get(i))) {
                                collector.add(F.C1);
                                continue;
                            }
                            collector.add(F.C0);
                            continue;
                        }
                        collector.add(F.C0);
                        continue;
                    }
                    if (((IExpr)arg1.get(i)).isPower()) {
                        IAST pow = (IAST)arg1.get(i);
                        if (((IPatternMatcher)matcher).apply(pow.arg1())) {
                            collector.add(pow.arg2());
                            continue;
                        }
                        collector.add(F.C0);
                        continue;
                    }
                    if (((IExpr)arg1.get(i)).isTimes()) {
                        this.timesExponent((IAST)arg1.get(i), matcher, collector);
                        continue;
                    }
                    collector.add(F.C0);
                }
            } else if (arg1.isTimes()) {
                this.timesExponent(arg1, matcher, collector);
            }
        } else if (expr.isSymbol()) {
            PatternMatcher matcher = new PatternMatcher(form);
            if (matcher.apply(expr)) {
                collector.add(F.C1);
            } else {
                collector.add(F.C0);
            }
        } else {
            collector.add(F.C0);
        }
        IAST result = F.ast(sym);
        for (IExpr exponent : collector) {
            result.add(exponent);
        }
        return result;
    }

    private void timesExponent(IAST timesAST, IPatternMatcher matcher, Set<IExpr> collector) {
        boolean evaled = false;
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr argi = (IExpr)timesAST.get(i);
            if (argi.isPower()) {
                IAST pow = (IAST)timesAST.get(i);
                if (!matcher.apply(pow.arg1())) continue;
                collector.add(pow.arg2());
                evaled = true;
                break;
            }
            if (!argi.isSymbol() || !matcher.apply(argi)) continue;
            collector.add(F.C1);
            evaled = true;
            break;
        }
        if (!evaled) {
            collector.add(F.C0);
        }
    }
}

