/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.List;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Expand;

public class ExpandAll
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        IExpr temp;
        Validate.checkRange(ast, 2, 3);
        IExpr arg1 = ast.arg1();
        IExpr patt = null;
        if (ast.size() > 2) {
            patt = ast.arg2();
        }
        if (arg1.isAST() && (temp = ExpandAll.expandAll((IAST)arg1, patt)) != null) {
            return temp;
        }
        return arg1;
    }

    public static IExpr expandAll(IAST ast, IExpr patt) {
        if (patt != null && ast.isFree(patt, true)) {
            return null;
        }
        List result = null;
        IExpr temp = null;
        for (int i = 1; i < ast.size(); ++i) {
            if (!((IExpr)ast.get(i)).isAST() || (temp = ExpandAll.expandAll((IAST)ast.get(i), patt)) == null) continue;
            if (result == null) {
                result = ast.setAtClone(i, temp);
                continue;
            }
            result.set(i, temp);
        }
        if (result == null) {
            return Expand.expand(ast, patt);
        }
        temp = Expand.expand(result, patt);
        if (temp != null) {
            return temp;
        }
        return result;
    }
}

