/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import java.util.ArrayList;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntegerSym;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class EulerE
extends AbstractTrigArg1 {
    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        if (arg1.isInteger()) {
            try {
                int n = ((IntegerSym)arg1).toInt();
                if ((n & 1) == 1) {
                    return F.C0;
                }
                n /= 2;
                ArrayList<BigInteger> a = new ArrayList<BigInteger>();
                if (a.size() == 0) {
                    a.add(BigInteger.ONE);
                    a.add(BigInteger.ONE);
                    a.add(new BigInteger("5"));
                    a.add(new BigInteger("61"));
                }
                BigInteger eulerE = this.eulerE(a, n);
                if (n > 0) {
                    --n;
                    if ((n %= 2) == 0) {
                        eulerE = eulerE.negate();
                    }
                }
                return F.ZZ(eulerE);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void set(ArrayList<BigInteger> a, int n) {
        while (n >= a.size()) {
            BigInteger val = BigInteger.ZERO;
            boolean sigPos = true;
            int thisn = a.size();
            for (int i = thisn - 1; i > 0; --i) {
                BigInteger f = a.get(i);
                f = f.multiply(BigIntegerMath.binomial(2 * thisn, 2 * i));
                val = sigPos ? val.add(f) : val.subtract(f);
                sigPos = !sigPos;
            }
            val = thisn % 2 == 0 ? val.subtract(BigInteger.ONE) : val.add(BigInteger.ONE);
            a.add(val);
        }
    }

    public BigInteger eulerE(ArrayList<BigInteger> a, int n) {
        this.set(a, n);
        return a.get(n);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
        super.setUp(symbol);
    }
}

